/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.session;

import de.intarsys.tools.session.ISession;
import de.intarsys.tools.session.ISessionProvider;
import java.util.ArrayDeque;
import java.util.Deque;

public class ThreadSessionProvider
implements ISessionProvider {
    private static final ThreadLocal<Deque<ISessionProvider>> CONTEXTS = ThreadLocal.withInitial(() -> new ArrayDeque());

    public void attach(ISessionProvider provider) {
        Deque<ISessionProvider> stack = CONTEXTS.get();
        stack.push(provider);
    }

    public void detach() {
        Deque<ISessionProvider> stack = CONTEXTS.get();
        stack.pop();
        if (stack.isEmpty()) {
            CONTEXTS.remove();
        }
    }

    @Override
    public ISession getSession() {
        Deque<ISessionProvider> stack = CONTEXTS.get();
        ISessionProvider temp = stack.peek();
        return temp == null ? null : temp.getSession();
    }
}

