/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.servicelocator;

import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.servicelocator.IServiceResolver;
import de.intarsys.tools.servicelocator.ServiceCreationException;
import de.intarsys.tools.servicelocator.ServiceImplementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceResolverDefaultImplementation<T>
implements IServiceResolver<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public T apply(Class<T> lookupClass) {
        ServiceImplementation implementation = lookupClass.getAnnotation(ServiceImplementation.class);
        if (implementation != null) {
            Class clazz = implementation.value();
            if (clazz == Void.TYPE) {
                clazz = implementation.defaultImplementation();
            }
            if (clazz != Void.TYPE) {
                try {
                    this.log.trace("ServiceResolver {} resolve {}", (Object)this, lookupClass);
                    T object = ObjectTools.createObject(clazz, lookupClass);
                    ObjectTools.initObject(object);
                    return object;
                }
                catch (ObjectCreationException e) {
                    throw new ServiceCreationException("service creation for " + lookupClass + " failed", e);
                }
            }
        }
        return null;
    }
}

