/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.servicelocator;

import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.servicelocator.IServiceResolver;
import de.intarsys.tools.servicelocator.ServiceCreationException;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceResolverConcreteImplementation<T>
implements IServiceResolver<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public T apply(Class<T> lookupClass) {
        try {
            if (!Modifier.isAbstract(lookupClass.getModifiers())) {
                this.log.trace("ServiceResolver {} resolve {}", (Object)this, lookupClass);
                T object = ObjectTools.createObject(lookupClass, lookupClass);
                ObjectTools.initObject(object);
                return object;
            }
            return null;
        }
        catch (ObjectCreationException e) {
            throw new ServiceCreationException("service creation for " + lookupClass + " failed", e);
        }
    }
}

