/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reporter;

import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.ReportStatus;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.reporter.IReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class DefaultReporter
implements IReporter {
    private final Logger logger;

    public DefaultReporter() {
        this(LoggerFactory.getLogger(DefaultReporter.class));
    }

    public DefaultReporter(Logger logger) {
        this.logger = logger;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public IProgressMonitor reportActivityStart(IMessage msg, int style) {
        ReportStatus activity = new ReportStatus<IActivity<?>>(null){

            @Override
            public void begin(String name, float totalWork) {
                DefaultReporter.this.getLogger().trace("{} begin", (Object)this.getFullName());
                super.begin(name, totalWork);
            }

            @Override
            protected void onFinally() {
                DefaultReporter.this.getLogger().trace("{} end", (Object)this.getFullName());
                super.onFinally();
            }

            @Override
            public void subTask(String name) {
                DefaultReporter.this.getLogger().trace("{} subtask {}", (Object)this.getFullName(), (Object)name);
                super.subTask(name);
            }

            @Override
            public void worked(float amount) {
                DefaultReporter.this.getLogger().trace("{} worked {}%", (Object)this.getFullName(), (Object)Float.valueOf(this.getWorkedPercent()));
                super.worked(amount);
            }
        };
        activity.setMessage(msg);
        activity.enter();
        if (this.getLogger().isEnabledForLevel(Level.TRACE)) {
            this.getLogger().error("start activity " + msg);
        }
        return activity;
    }

    @Override
    public void reportError(String title, String message, Throwable t, int style) {
        this.getLogger().error(message, t);
    }

    @Override
    public void reportMessage(String title, String message, int style) {
        this.getLogger().info(message);
    }

    @Override
    public void reportStatus(String text, int style) {
        this.getLogger().info(text);
    }
}

