/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reporter;

import de.intarsys.tools.activity.ReportStatus;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.reporter.AWTReporterDialog;
import de.intarsys.tools.reporter.IReporter;
import java.awt.Frame;
import java.awt.Toolkit;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class AWTReporter
implements IReporter {
    private static final Attribute ATTR_DIALOG = new Attribute("dialog");
    private boolean standalone;

    protected void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    protected AWTReporterDialog createDialog(String message) {
        Frame parent = JOptionPane.getFrameForComponent(null);
        AWTReporterDialog dialog = new AWTReporterDialog(parent, "", message);
        return dialog;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    @Override
    public IProgressMonitor reportActivityStart(final IMessage message, int style) {
        final ReportStatus activity = new ReportStatus(null){

            @Override
            protected void onFinally() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AWTReporterDialog dialog = (AWTReporterDialog)this.getAttribute(ATTR_DIALOG);
                        if (dialog != null) {
                            dialog.setVisible(false);
                            dialog.dispose();
                            this.setAttribute(ATTR_DIALOG, null);
                        }
                    }
                });
                super.onFinally();
            }

            @Override
            public void worked(float amount) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AWTReporterDialog dialog = (AWTReporterDialog)this.getAttribute(ATTR_DIALOG);
                        if (dialog != null) {
                            dialog.setMessage(this.getFullName());
                            dialog.setProgress((int)this.getWorkedPercent());
                        }
                    }
                });
                super.worked(amount);
            }
        };
        activity.setMessage(message);
        if ((style & 2) != 0) {
            this.beep();
        }
        activity.enter();
        if (this.isStandalone() || (style & 1) != 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AWTReporterDialog dialog = AWTReporter.this.createDialog(message.getString());
                    activity.setAttribute(ATTR_DIALOG, dialog);
                    dialog.setVisible(true);
                }
            });
        }
        return activity;
    }

    @Override
    public void reportError(String title, String message, Throwable t, int style) {
        JOptionPane.showMessageDialog(null, message, title, 0);
    }

    @Override
    public void reportMessage(String title, String message, int style) {
        JOptionPane.showMessageDialog(null, message, title, 1);
    }

    @Override
    public void reportStatus(String message, int style) {
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }
}

