/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reader;

import de.intarsys.tools.collection.SimpleEntry;
import de.intarsys.tools.reader.TaggedReader;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.string.Token;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class ReaderTools {
    public static InputStreamReader createReaderScanBom(InputStream is) throws IOException {
        String encoding = null;
        is.mark(4);
        int i = is.read();
        if (i == 0) {
            i = is.read();
            if (i == 0 && (i = is.read()) == 254 && (i = is.read()) == 255) {
                encoding = "UTF-32BE";
            }
        } else if (i == 255) {
            i = is.read();
            if (i == 254) {
                is.mark(4);
                i = is.read();
                if (i == 0 && (i = is.read()) == 0) {
                    encoding = "UTF-32LE";
                }
                if (encoding == null) {
                    is.reset();
                    encoding = "UTF-16LE";
                }
            }
        } else if (i == 254) {
            i = is.read();
            if (i == 255) {
                encoding = "UTF-16BE";
            }
        } else if (i == 239 && (i = is.read()) == 187 && (i = is.read()) == 191) {
            encoding = "UTF-8";
        }
        if (encoding == null) {
            is.reset();
            return null;
        }
        return new InputStreamReader(is, encoding);
    }

    public static InputStreamReader createReaderScanMeta(final InputStream is) throws IOException {
        Reader tempReader = new Reader(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void mark(int readlimit) throws IOException {
                is.mark(readlimit);
            }

            @Override
            public boolean markSupported() {
                return is.markSupported();
            }

            @Override
            public int read() throws IOException {
                return is.read();
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                return -1;
            }

            @Override
            public void reset() throws IOException {
                is.reset();
            }
        };
        String encoding = ReaderTools.readMetaEncoding(tempReader);
        if (encoding != null) {
            return new InputStreamReader(is, encoding);
        }
        return null;
    }

    public static TaggedReader createTaggedReader(InputStream is, String defaultCharsetName, int size) throws IOException {
        InputStreamReader reader = ReaderTools.createReaderScanBom(is);
        if (reader == null && (reader = ReaderTools.createReaderScanMeta(is)) == null) {
            reader = defaultCharsetName == null ? new InputStreamReader(is) : new InputStreamReader(is, defaultCharsetName);
        }
        TaggedReader tagged = new TaggedReader(reader, size);
        return tagged;
    }

    public static Map.Entry<String, String> readEntry(Reader reader, char delimiter) throws IOException {
        String key = "";
        String value = "";
        StringBuilder sb = new StringBuilder();
        boolean readKey = true;
        boolean quoted = false;
        boolean ignore = false;
        while (true) {
            int i;
            if ((i = reader.read()) == 61 && readKey) {
                key = sb.toString().trim();
                sb.setLength(0);
                readKey = false;
                continue;
            }
            if (i == 92 && quoted) {
                String mapped;
                i = reader.read();
                if (i == -1 || (mapped = StringTools.ESCAPES.get(Character.valueOf((char)i))) == null) continue;
                sb.append(mapped);
                continue;
            }
            if (i == 34 && !readKey) {
                if (quoted) {
                    quoted = false;
                    ignore = true;
                    continue;
                }
                if (sb.length() == 0) {
                    quoted = true;
                    continue;
                }
                if (ignore) continue;
                sb.append((char)i);
                continue;
            }
            if (i == -1) {
                if (readKey) {
                    key = sb.toString().trim();
                    value = "";
                } else {
                    value = sb.toString();
                }
                if (key.length() > 0) {
                    return new SimpleEntry<String, String>(key, value);
                }
                if (value.length() > 0) {
                    return new SimpleEntry<String, String>(key, value);
                }
                return null;
            }
            if (i == 13 && !quoted && delimiter == '\n') continue;
            if (i == delimiter && !quoted) {
                if (readKey) {
                    key = sb.toString().trim();
                    value = "";
                } else {
                    value = sb.toString();
                }
                if (key.length() > 0) {
                    return new SimpleEntry<String, String>(key, value);
                }
                if (value.length() > 0) {
                    return new SimpleEntry<String, String>(key, value);
                }
                return new SimpleEntry<Object, Object>(null, null);
            }
            if (readKey) {
                sb.append((char)i);
                continue;
            }
            if (ignore) continue;
            sb.append((char)i);
        }
    }

    public static Map<String, String> readMetaData(Reader reader) throws IOException {
        HashMap<String, String> meta = new HashMap<String, String>();
        while (true) {
            reader.mark(1024);
            int i = reader.read();
            if (i != 36 || (i = reader.read()) != 36 || (i = reader.read()) != 36) break;
            Map.Entry<String, String> entry = ReaderTools.readEntry(reader, '\n');
            if (entry.getKey() == null) continue;
            meta.put(entry.getKey(), entry.getValue());
        }
        reader.reset();
        return meta;
    }

    public static String readMetaEncoding(Reader reader) throws IOException {
        Map.Entry<String, String> entry;
        reader.mark(1024);
        int i = reader.read();
        if (i == 36 && (i = reader.read()) == 36 && (i = reader.read()) == 36 && "encoding".equals((entry = ReaderTools.readEntry(reader, '\n')).getKey())) {
            reader.reset();
            return entry.getValue();
        }
        reader.reset();
        return null;
    }

    public static Token readPaired(Reader reader, char openChar, char closeChar) throws IOException {
        StringBuilder sb = new StringBuilder();
        int depth = 1;
        int i;
        while ((i = reader.read()) != -1) {
            if (i == closeChar) {
                if (--depth == 0) {
                    return new Token(sb.toString());
                }
            } else if (i == openChar) {
                ++depth;
            }
            sb.append((char)i);
        }
        return new Token(sb.toString());
    }

    public static int readSkipWS(Reader reader) throws IOException {
        int i;
        do {
            if ((i = reader.read()) != -1) continue;
            return i;
        } while (Character.isWhitespace((char)i));
        return i;
    }

    public static Token readToken(Reader reader, char delimiter) throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean quoted = false;
        char quote = '\u0000';
        boolean ignore = false;
        while (true) {
            char i;
            if ((i = reader.read()) == '\\' && quoted) {
                String mapped;
                i = reader.read();
                if (i == '\uffffffff' || (mapped = StringTools.ESCAPES.get(Character.valueOf(i))) == null) continue;
                sb.append(mapped);
                continue;
            }
            if (i == '\r' && !quoted && delimiter == '\n') continue;
            if (i == '\"' || i == '\'') {
                if (quoted) {
                    if (i == quote) {
                        quoted = false;
                        ignore = true;
                        continue;
                    }
                    if (ignore) continue;
                    sb.append(i);
                    continue;
                }
                if (sb.length() == 0) {
                    quote = i;
                    quoted = true;
                    continue;
                }
                if (ignore) continue;
                sb.append(i);
                continue;
            }
            if (i == '\uffffffff') {
                if (quote == '\u0000' && sb.length() == 0) {
                    return null;
                }
                return new Token(sb.toString(), quote, true);
            }
            if (i == delimiter && !quoted) {
                return new Token(sb.toString(), quote);
            }
            if (ignore) continue;
            sb.append(i);
        }
    }

    private ReaderTools() {
    }
}

