/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.AbstractRandomAccess;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;

public class RandomAccessViewport
extends AbstractRandomAccess {
    private final IRandomAccess randomAccess;
    private final long start;
    private final long length;

    public RandomAccessViewport(IRandomAccess randomAccess, long start, long length) {
        this.randomAccess = randomAccess;
        this.start = start;
        this.length = length == -1L ? Long.MAX_VALUE : length;
    }

    @Override
    public void close() throws IOException {
        this.randomAccess.close();
    }

    @Override
    public void flush() throws IOException {
        this.randomAccess.flush();
    }

    @Override
    public long getLength() throws IOException {
        return Math.min(this.length, this.randomAccess.getLength() - this.start);
    }

    @Override
    public long getOffset() throws IOException {
        return this.randomAccess.getOffset() - this.start;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public int read() throws IOException {
        long offset = this.getOffset();
        if (offset < 0L) {
            throw new IOException("Negative offset");
        }
        return offset < this.length ? this.randomAccess.read() : -1;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int start, int numBytes) throws IOException {
        long offset = this.getOffset();
        if (offset < 0L) {
            throw new IOException("Negative offset");
        }
        return offset < this.length ? this.randomAccess.read(buffer, start, Math.min(numBytes, (int)(this.length - offset))) : -1;
    }

    @Override
    public void seek(long offset) throws IOException {
        if (offset < 0L) {
            throw new IOException("Negative seek offset");
        }
        this.randomAccess.seek(this.start + offset);
    }

    @Override
    public void seekBy(long delta) throws IOException {
        long offset = this.getOffset();
        if (offset + delta < 0L) {
            throw new IOException("Negative seek offset");
        }
        this.randomAccess.seekBy(delta);
    }

    @Override
    public void setLength(long length) throws IOException {
        throw new IOException("Length cannot be changed");
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        throw new IOException("Read-only random access");
    }

    @Override
    public void write(byte[] buffer, int start, int numBytes) throws IOException {
        throw new IOException("Read-only random access");
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("Read-only random access");
    }
}

