/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.io.InputStream;

public class RandomAccessInputStream
extends InputStream {
    private final IRandomAccess randomAccess;
    private long offset;

    public RandomAccessInputStream(IRandomAccess randomAccess) {
        this(randomAccess, 0L);
    }

    public RandomAccessInputStream(IRandomAccess randomAccess, long offset) {
        this.randomAccess = randomAccess;
        this.offset = offset;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read() throws IOException {
        this.randomAccess.seek(this.offset);
        int i = this.randomAccess.read();
        if (i != -1) {
            ++this.offset;
        }
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.randomAccess.seek(this.offset);
        int i = this.randomAccess.read(b);
        if (i != -1) {
            this.offset += (long)i;
        }
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.randomAccess.seek(this.offset);
        int i = this.randomAccess.read(b, off, len);
        if (i != -1) {
            this.offset += (long)i;
        }
        return i;
    }
}

