/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.objectmodel;

import de.intarsys.tools.exception.InitializationException;
import de.intarsys.tools.objectmodel.IClass;
import de.intarsys.tools.objectmodel.IClassSelector;
import de.intarsys.tools.objectmodel.ObjectModelTools;
import jakarta.annotation.PostConstruct;
import java.util.List;

public class ObjectModelClassDeclaration {
    private String implementor;
    private List<String> aliases;

    public List<String> getAliases() {
        return this.aliases;
    }

    public String getImplementor() {
        return this.implementor;
    }

    @PostConstruct
    public void install() {
        try {
            IClassSelector selector = ObjectModelTools.createSelector(this.getImplementor());
            IClass clazz = ObjectModelTools.registerClass(selector);
            if (this.getAliases() != null) {
                for (String alias : this.getAliases()) {
                    IClassSelector aliasSelector = ObjectModelTools.createSelector(alias);
                    ObjectModelTools.registerClass(aliasSelector, clazz);
                }
            }
        }
        catch (Exception e) {
            throw new InitializationException(e);
        }
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public void setImplementor(String implementor) {
        this.implementor = implementor;
    }
}

