/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.number;

import de.intarsys.tools.number.NumberInstance;
import de.intarsys.tools.number.NumberInterval;
import de.intarsys.tools.number.NumberList;
import de.intarsys.tools.number.NumberWrapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class NumberParser {
    private final boolean integer;

    public static NumberWrapper parse(String value) throws IOException {
        if (value == null) {
            return null;
        }
        return new NumberParser(false).parse(new StringReader(value));
    }

    public static NumberWrapper parseInteger(String value) throws IOException {
        if (value == null) {
            return null;
        }
        return new NumberParser(true).parse(new StringReader(value));
    }

    protected NumberParser(boolean integer) {
        this.integer = integer;
    }

    public boolean isInteger() {
        return this.integer;
    }

    protected boolean isIntervalSeparator(char c) {
        return c == '-';
    }

    protected boolean isListSeparator(char c) {
        return c == ';';
    }

    protected boolean isNumberChar(char c) {
        return c == '.' && !this.isInteger() || c >= '0' && c <= '9' || c == '-' || c == '+';
    }

    protected NumberWrapper parse(StringReader r) throws IOException {
        NumberList numberList = new NumberList();
        this.parse(r, numberList);
        return numberList;
    }

    protected void parse(StringReader r, NumberList numberList) throws IOException {
        StringBuilder sb = new StringBuilder();
        Double number = null;
        NumberInterval interval = null;
        int i = r.read();
        while (i > -1) {
            char c = (char)i;
            if (!Character.isWhitespace(c)) {
                if (this.isListSeparator(c)) {
                    if (interval != null) {
                        if (interval.getTo() == null) {
                            throw new IOException("number expected");
                        }
                        numberList.add(interval);
                        interval = null;
                        number = null;
                    } else if (number != null) {
                        numberList.add(new NumberInstance(number));
                        number = null;
                    }
                } else if (number != null && this.isIntervalSeparator(c)) {
                    interval = new NumberInterval();
                    interval.setFrom(number);
                    number = null;
                } else if (this.isNumberChar(c)) {
                    if (number != null) {
                        throw new IOException("invalid char '" + c + "'");
                    }
                    sb.setLength(0);
                    sb.append(c);
                    number = this.parseNumber(r, sb);
                    if (interval != null) {
                        interval.setTo(number);
                    }
                } else {
                    throw new IOException("number expected");
                }
            }
            i = r.read();
        }
        if (interval != null) {
            if (interval.getTo() == null) {
                throw new IOException("number expected");
            }
            numberList.add(interval);
        } else if (number != null) {
            numberList.add(new NumberInstance(number));
        }
    }

    protected Double parseNumber(Reader r, StringBuilder sb) throws IOException {
        char c;
        r.mark(1);
        int i = r.read();
        while (!(i == -1 || Character.isWhitespace(c = (char)i) || this.isListSeparator(c) || this.isIntervalSeparator(c))) {
            if (!this.isNumberChar(c)) {
                throw new IOException("invalid char '" + c + "'");
            }
            sb.append(c);
            r.mark(1);
            i = r.read();
        }
        r.reset();
        try {
            return this.toNumber(sb);
        }
        catch (Exception e) {
            throw new IOException("number format exception");
        }
    }

    protected double toNumber(StringBuilder sb) {
        return Double.parseDouble(sb.toString());
    }
}

