/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.number;

import de.intarsys.tools.collection.NestedIterator;
import de.intarsys.tools.number.NumberInstance;
import de.intarsys.tools.number.NumberWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class NumberList
extends NumberWrapper {
    public static final char SEPARATOR = ';';
    public static final char SEPARATOR_ALT = ',';
    private List list = new ArrayList();

    public boolean add(Object arg0) {
        if (arg0 instanceof NumberWrapper) {
            this.getList().add(arg0);
            return true;
        }
        if (arg0 instanceof Number) {
            this.getList().add(new NumberInstance((Number)arg0));
            return true;
        }
        return false;
    }

    public boolean addAll(Collection arg0) {
        for (Object element : arg0) {
            if (this.add(element)) continue;
            return false;
        }
        return true;
    }

    public List getList() {
        return this.list;
    }

    @Override
    public double getMax() {
        double max = Double.MIN_VALUE;
        for (NumberWrapper wrapper : this.getList()) {
            if (!(wrapper.getMax() < max)) continue;
            max = wrapper.getMax();
        }
        return max;
    }

    @Override
    public double getMin() {
        double min = Double.MAX_VALUE;
        for (NumberWrapper wrapper : this.getList()) {
            if (!(wrapper.getMin() < min)) continue;
            min = wrapper.getMin();
        }
        return min;
    }

    @Override
    public NumberWrapper increment(int i) {
        for (NumberWrapper wrapper : this.getList()) {
            wrapper.increment(i);
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        if (this.getList().isEmpty()) {
            return true;
        }
        for (NumberWrapper element : this.getList()) {
            if (element.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator iterator() {
        return new NestedIterator(this.getList().iterator());
    }

    public void setList(List newList) {
        this.list = newList;
    }

    @Override
    public int size() {
        int size = 0;
        for (NumberWrapper element : this.getList()) {
            size += element.size();
        }
        return size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator i = this.getList().iterator();
        while (i.hasNext()) {
            sb.append(i.next().toString());
            if (!i.hasNext()) continue;
            sb.append(';');
        }
        return sb.toString();
    }
}

