/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.number;

import de.intarsys.tools.collection.SingleObjectIterator;
import de.intarsys.tools.number.NumberWrapper;
import java.text.NumberFormat;
import java.util.Iterator;

public class NumberInstance
extends NumberWrapper {
    private Number n;

    public NumberInstance(double i) {
        this.n = i;
    }

    public NumberInstance(int i) {
        this.n = i;
    }

    public NumberInstance(Number number) {
        this.n = number;
    }

    public NumberInstance(String numberValueInString) {
        int zahl = Integer.parseInt(numberValueInString);
        this.n = zahl;
    }

    public boolean add(Object arg0) {
        if (arg0 instanceof Number) {
            this.n = (Number)arg0;
            return true;
        }
        if (arg0 instanceof NumberWrapper && !((NumberWrapper)arg0).isEmpty()) {
            this.n = ((NumberWrapper)arg0).getFirst();
            return true;
        }
        throw new IllegalArgumentException("Only objects of type Number or NumberWrapper are supported.");
    }

    public boolean contains(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue() == this.n.doubleValue();
        }
        if (o instanceof NumberWrapper && !((NumberWrapper)o).isEmpty()) {
            return ((NumberWrapper)o).getFirst().doubleValue() == this.n.doubleValue();
        }
        return false;
    }

    @Override
    public double getMax() {
        return this.n.doubleValue();
    }

    @Override
    public double getMin() {
        return this.n.doubleValue();
    }

    public Number getN() {
        return this.n;
    }

    @Override
    public NumberWrapper increment(int i) {
        this.n = this.getN().intValue() + i;
        return this;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator iterator() {
        return new SingleObjectIterator<Number>(this.getN());
    }

    @Override
    public int size() {
        return 1;
    }

    public String toString() {
        return NumberFormat.getInstance().format(this.getN());
    }
}

