/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.format.TrivialDateFormat;
import de.intarsys.tools.monitor.Monitor;
import de.intarsys.tools.monitor.MonitorSample;
import de.intarsys.tools.monitor.MonitorStatistic;
import de.intarsys.tools.monitor.MonitorTrace;
import de.intarsys.tools.monitor.TimeMonitorTrace;
import java.text.Format;
import java.util.Iterator;
import java.util.List;

public class TimeMonitor
extends Monitor {
    private static final Format DEFAULT_FORMAT = TrivialDateFormat.getInstance();

    public TimeMonitor() {
    }

    public TimeMonitor(String name) {
        super(name);
    }

    @Override
    protected TimeMonitorTrace createMonitorTrace() {
        return new TimeMonitorTrace(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCalculation(MonitorTrace trace) {
        long start = trace.getStart();
        long diff = trace.getDifference();
        this.doStatistic(this.statistic, diff);
        List samples = trace.getSamples();
        if (samples != null) {
            Iterator sampleIt = samples.iterator();
            int i = 0;
            while (sampleIt.hasNext()) {
                MonitorStatistic sampleStatistic;
                MonitorSample sample = (MonitorSample)sampleIt.next();
                diff = sample.getValue() - start;
                start = sample.getValue();
                TimeMonitor timeMonitor = this;
                synchronized (timeMonitor) {
                    sampleStatistic = (MonitorStatistic)this.sampleStatistics.get(sample.getDescription());
                    if (sampleStatistic == null) {
                        sampleStatistic = new MonitorStatistic(sample.getDescription(), i);
                        this.sampleStatistics.put(sample.getDescription(), sampleStatistic);
                    }
                }
                this.doStatistic(sampleStatistic, diff);
                ++i;
            }
        }
    }

    protected void doStatistic(MonitorStatistic sampleStatistic, long diff) {
        if (diff < sampleStatistic.min) {
            sampleStatistic.min = diff;
        }
        if (diff > sampleStatistic.max) {
            sampleStatistic.max = diff;
        }
        sampleStatistic.total += diff;
        ++sampleStatistic.count;
        sampleStatistic.avg = sampleStatistic.total / sampleStatistic.count;
    }

    @Override
    protected Format getFormat() {
        return DEFAULT_FORMAT;
    }
}

