/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.CommonMessageBundle;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.OverrideMessageBundleFactory;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverrideMessageBundle
extends CommonMessageBundle {
    private static final Logger Log = LoggerFactory.getLogger((String)"NLS");
    private IMessageBundle overrideBundle;
    private final Map<String, String> overrides = new HashMap<String, String>();

    public OverrideMessageBundle(OverrideMessageBundleFactory factory, String name) {
        super(factory, name, null);
    }

    protected void clear() {
        this.overrides.clear();
    }

    @Override
    public Set<String> getCodes() {
        HashSet<String> codes = new HashSet<String>();
        codes.addAll(this.overrides.keySet());
        if (this.getOverrideBundle() != null) {
            codes.addAll(this.getOverrideBundle().getCodes());
        }
        return codes;
    }

    protected IMessageBundle getOverrideBundle() {
        return this.overrideBundle;
    }

    @Override
    public String getPattern(String code) {
        String result = this.overrides.get(code);
        if (result == null && this.getOverrideBundle() != null) {
            result = this.getOverrideBundle().getPattern(code);
        }
        if (this.isLogMode()) {
            Log.info("ExtendedMessageBundle.getPattern,{},{},{}", new Object[]{this.getName(), code, result});
        }
        return result;
    }

    @Override
    public String getString(String code, Object ... args) {
        Object result = null;
        if (this.isRawMode()) {
            result = "{" + code + "}";
        } else {
            String pattern = this.overrides.get(code);
            if (pattern != null) {
                result = this.format(pattern, args);
            }
            if (result == null && this.getOverrideBundle() != null && this.getOverrideBundle().getPattern(code) != null) {
                result = this.getOverrideBundle().getString(code, args);
            }
        }
        if (this.isLogMode()) {
            Log.info("ExtendedMessageBundle.getString,{},{},{}", new Object[]{this.getName(), code, result});
        }
        return result;
    }

    @Override
    protected boolean isLogMode() {
        return this.getFactory().isLogMode();
    }

    @Override
    protected boolean isRawMode() {
        return this.getFactory().isRawMode();
    }

    protected void load(ILocator locator) throws IOException {
        Properties properties = new Properties();
        InputStream is = null;
        try {
            is = locator.getInputStream();
            properties.load(is);
        }
        catch (Exception e) {
            StreamTools.close(is);
            throw e;
        }
        this.overrides.putAll(new HashMap<Object, Object>(properties));
    }

    protected void register(String code, String pattern) {
        this.overrides.put(code, pattern);
    }

    protected void setOverrideBundle(IMessageBundle overrideBundle) {
        this.overrideBundle = overrideBundle;
    }

    protected void unregister(String code) {
        this.overrides.remove(code);
    }
}

