/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.content.ICharsetAccess;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.string.StringTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;

public class StringLocator
extends CommonLocator
implements ICharsetAccess {
    private final String content;
    private String charset = System.getProperty("file.encoding");
    private String fullName;

    public StringLocator(String content, String pFullName) {
        this.content = content;
        this.setFullName(pFullName);
    }

    public StringLocator(String content, String pName, String pType) {
        this.content = content;
        if (StringTools.isEmpty(pType)) {
            this.setFullName(pName);
        } else {
            this.setFullName(pName + "." + pType);
        }
    }

    @Override
    public void delete() throws IOException {
    }

    @Override
    public boolean exists() {
        return this.getContent() != null;
    }

    protected byte[] getBytes() {
        byte[] bytes;
        try {
            bytes = this.getContent().getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            bytes = this.getContent().getBytes();
        }
        return bytes;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public ILocator getChild(String child) {
        return null;
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        byte[] bytes = this.getBytes();
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public long getLength() throws IOException {
        return this.getBytes().length;
    }

    @Override
    public String getName() {
        return PathTools.getName(this.fullName);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("locator is read only");
    }

    @Override
    public ILocator getParent() {
        return null;
    }

    @Override
    public String getPath() {
        return this.fullName;
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        byte[] bytes = this.getBytes();
        return new RandomAccessByteArray(bytes);
    }

    @Override
    public Reader getReader() throws IOException {
        return new StringReader(this.getContent());
    }

    @Override
    public Reader getReader(String encoding) throws IOException {
        return new StringReader(this.getContent());
    }

    @Override
    public Writer getWriter() throws IOException {
        throw new IOException("locator is read only");
    }

    @Override
    public Writer getWriter(String encoding) throws IOException {
        throw new IOException("locator is read only");
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        return new ILocator[0];
    }

    @Override
    public void rename(String newName) throws IOException {
        this.setFullName(newName);
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    protected void setFullName(String newName) {
        this.fullName = newName;
    }

    @Override
    public void synch() {
    }

    @Override
    public URI toURI() {
        return URI.create("string:[a]" + this.getContent());
    }
}

