/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.locator.BasicLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.PreferencesTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.prefs.BackingStoreException;

@SingletonClass
public class LocatorUsage {
    public static final String DEFAULT_CONTEXT = "main";
    public static final Attribute ATTR_LOCATORRECENTCONTEXT = new Attribute("recentContext");
    public static final int MAXRECENT = 4;
    private static final LocatorUsage INSTANCE = new LocatorUsage();
    public static final String ACTION_ANY = "any";
    public static final String CONTEXT_ANY = "any";
    private static final String PREF_LOCATORUSE = "locatorUse";
    private static final String PREF_LOCATORUSERECENT = "locatorUseRecent";
    private static final String ATTR_LOCATOR = "locator";
    public static final String ACTION_LOAD = "load";
    public static final String ACTION_SAVE = "save";
    private Supplier<String> sharedContextProvider;
    private String lastLocation = System.getProperty("user.dir");
    private final Map lastLocationPerAction = new HashMap();
    private final Map lastLocationPerActionAndContext = new HashMap();
    private final Map<String, List<String>> recentLocationsPerContext = new HashMap<String, List<String>>();

    public static LocatorUsage get() {
        return INSTANCE;
    }

    protected static ILocator toLocator(String value, ILocator defaultValue) {
        if (value != null && value.length() > 0) {
            try {
                return BasicLocatorFactory.get().createLocator(value);
            }
            catch (IOException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecentLocator(String recentContext, ILocator pLocator) {
        if (recentContext == null) {
            return;
        }
        if (pLocator == null) {
            return;
        }
        String tempLocation = pLocator.getPath();
        Map<String, List<String>> map = this.recentLocationsPerContext;
        synchronized (map) {
            List recent = this.recentLocationsPerContext.computeIfAbsent(recentContext, key -> new ArrayList());
            recent.remove(tempLocation);
            recent.add(0, tempLocation);
            while (recent.size() > 4) {
                recent.remove(4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRecentLocators(String recentContext) {
        Map<String, List<String>> map = this.recentLocationsPerContext;
        synchronized (map) {
            this.recentLocationsPerContext.remove(recentContext);
        }
    }

    public String getLastLocator() {
        return this.lastLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastLocator(String action) {
        Map map = this.lastLocationPerAction;
        synchronized (map) {
            return (String)this.lastLocationPerAction.get(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastLocator(String action, String context) {
        Map map = this.lastLocationPerActionAndContext;
        synchronized (map) {
            Map contextLocators = (Map)this.lastLocationPerActionAndContext.get(action);
            if (contextLocators == null) {
                return null;
            }
            return (String)contextLocators.get(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRecentLocators(String context) {
        Map<String, List<String>> map = this.recentLocationsPerContext;
        synchronized (map) {
            List<String> recent = this.recentLocationsPerContext.get(context);
            if (recent == null) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(recent);
        }
    }

    public String getSharedContext() {
        return this.sharedContextProvider == null ? null : this.sharedContextProvider.get();
    }

    public Supplier<String> getSharedContextProvider() {
        return this.sharedContextProvider;
    }

    public void preferencesRestore(IPreferences preferences) {
        try {
            IPreferences prefLocatorUse = preferences.node(PREF_LOCATORUSE);
            String[] actionNames = prefLocatorUse.childrenNames();
            for (int i = 0; i < actionNames.length; ++i) {
                String actionName = actionNames[i];
                IPreferences prefActionLocator = prefLocatorUse.node(actionName);
                String[] contextNames = prefActionLocator.childrenNames();
                for (int j = 0; j < contextNames.length; ++j) {
                    String contextName = contextNames[j];
                    IPreferences prefContextLocator = prefActionLocator.node(contextName);
                    String locatorDef = prefContextLocator.get(ATTR_LOCATOR);
                    this.setLastLocator(actionName, contextName, LocatorUsage.toLocator(locatorDef, null));
                }
                String locatorDef = prefActionLocator.get(ATTR_LOCATOR);
                this.setLastLocator(actionName, LocatorUsage.toLocator(locatorDef, null));
            }
            String locatorDef = prefLocatorUse.get(ATTR_LOCATOR);
            this.setLastLocator(LocatorUsage.toLocator(locatorDef, null));
            IPreferences prefLocatorRecent = preferences.node(PREF_LOCATORUSERECENT);
            String[] contextNames = prefLocatorRecent.keys();
            for (int i = 0; i < contextNames.length; ++i) {
                String contextName = contextNames[i];
                String locatorsDef = prefLocatorRecent.get(contextName);
                String[] locatorsDefArray = PreferencesTools.toStringArray(locatorsDef);
                for (int j = locatorsDefArray.length - 1; j >= 0; --j) {
                    this.addRecentLocator(contextName, LocatorUsage.toLocator(locatorsDefArray[j], null));
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preferencesStore(IPreferences preferences) {
        HashMap<String, List<String>> tempContextRecentLocations;
        Object actionName;
        HashMap tempActionContextLocations;
        HashMap tempActionLocations;
        IPreferences prefLocatorUse = preferences.node(PREF_LOCATORUSE);
        prefLocatorUse.put(ATTR_LOCATOR, this.getLastLocator());
        Map map = this.lastLocationPerAction;
        synchronized (map) {
            tempActionLocations = new HashMap(this.lastLocationPerAction);
        }
        for (Map.Entry entry : tempActionLocations.entrySet()) {
            String actionName2 = (String)entry.getKey();
            String tempLocations = (String)entry.getValue();
            IPreferences prefActionLocator = prefLocatorUse.node(actionName2);
            prefActionLocator.put(ATTR_LOCATOR, tempLocations);
        }
        Map map2 = this.lastLocationPerActionAndContext;
        synchronized (map2) {
            tempActionContextLocations = new HashMap(this.lastLocationPerActionAndContext);
        }
        for (Map.Entry acEntry : tempActionContextLocations.entrySet()) {
            actionName = (String)acEntry.getKey();
            Map contextLocators = (Map)acEntry.getValue();
            IPreferences prefActionLocator = prefLocatorUse.node((String)actionName);
            for (Map.Entry cEntry : contextLocators.entrySet()) {
                String contextName = (String)cEntry.getKey();
                String tempLocation = (String)cEntry.getValue();
                IPreferences prefActionContextLocator = prefActionLocator.node(contextName);
                prefActionContextLocator.put(ATTR_LOCATOR, tempLocation);
            }
        }
        IPreferences iPreferences = preferences.node(PREF_LOCATORUSERECENT);
        actionName = this.recentLocationsPerContext;
        synchronized (actionName) {
            tempContextRecentLocations = new HashMap<String, List<String>>(this.recentLocationsPerContext);
        }
        for (Map.Entry entry3 : tempContextRecentLocations.entrySet()) {
            String contextName = (String)entry3.getKey();
            List tempLocations = (List)entry3.getValue();
            iPreferences.put(contextName, PreferencesTools.toString(tempLocations));
        }
    }

    public void setLastLocator(ILocator pLocator) {
        if (pLocator == null) {
            return;
        }
        this.lastLocation = pLocator.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastLocator(String action, ILocator pLocator) {
        if (pLocator == null) {
            return;
        }
        Map map = this.lastLocationPerAction;
        synchronized (map) {
            this.lastLocationPerAction.put(action, pLocator.getPath());
        }
        this.setLastLocator(pLocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastLocator(String action, String context, ILocator pLocator) {
        if (pLocator == null || action == null || context == null) {
            return;
        }
        Map map = this.lastLocationPerActionAndContext;
        synchronized (map) {
            Map contextLocators = (Map)this.lastLocationPerActionAndContext.computeIfAbsent(action, key -> new HashMap());
            contextLocators.put(context, pLocator.getPath());
        }
        this.setLastLocator(action, pLocator);
    }

    public void setSharedContextProvider(Supplier<String> sharedContextProvider) {
        this.sharedContextProvider = sharedContextProvider;
    }
}

