/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocatorFactory;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.PrettyPrinter;
import de.intarsys.tools.valueholder.IValueHolder;
import de.intarsys.tools.valueholder.ObjectHolder;
import de.intarsys.tools.valueholder.ValueHolderAdapter;
import java.io.File;
import java.io.IOException;

public class FileLocatorFactory
extends CommonLocatorFactory {
    public static final FileLocatorFactory BASEDIR = new FileLocatorFactory((IValueHolder<File>)new ValueHolderAdapter<File>(){

        @Override
        public File get() {
            return FileEnvironment.get().getBaseDir();
        }
    });
    public static final FileLocatorFactory DATADIR = new FileLocatorFactory((IValueHolder<File>)new ValueHolderAdapter<File>(){

        @Override
        public File get() {
            return FileEnvironment.get().getDataDir();
        }
    });
    public static final FileLocatorFactory PROFILEDIR = new FileLocatorFactory((IValueHolder<File>)new ValueHolderAdapter<File>(){

        @Override
        public File get() {
            return FileEnvironment.get().getProfileDir();
        }
    });
    private boolean synchSynchronous = true;
    private final IValueHolder<File> parent;

    public FileLocatorFactory() {
        this(FileEnvironment.get().getBaseDir());
    }

    public FileLocatorFactory(File file) {
        this.parent = new ObjectHolder<File>(file);
    }

    public FileLocatorFactory(IValueHolder<File> vh) {
        this.parent = vh;
    }

    @Override
    protected ILocator basicCreateLocator(String location) throws IOException {
        location = FileTools.trimPath(location);
        File absolutePath = FileTools.resolvePath(this.parent.get(), location);
        FileLocator result = new FileLocator(absolutePath);
        result.setSynchSynchronous(this.isSynchSynchronous());
        return result;
    }

    public boolean isSynchSynchronous() {
        return this.synchSynchronous;
    }

    public void setSynchSynchronous(boolean synchSynchronous) {
        this.synchSynchronous = synchSynchronous;
    }

    @Override
    public void toString(PrettyPrinter printer) {
        printer.appendValue("FileLocatorFactory on " + this.parent.get());
    }
}

