/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.xfs.XFSScanner;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;

public class ClassResourceLocator
extends CommonLocator {
    public static final String SEPARATOR = "/";
    private final Class<?> clazz;
    private final String resourceName;
    private final String resolvedName;
    private String encoding;
    private ILocator tempFileLocator;
    private URL resourceURL;

    public ClassResourceLocator(Class<?> clazz, String path) {
        this.clazz = clazz;
        this.resourceName = path;
        this.resolvedName = this.resolveName(path);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassResourceLocator)) {
            return false;
        }
        return this.resolvedName.equals(((ClassResourceLocator)obj).resolvedName) && this.clazz.equals(((ClassResourceLocator)obj).clazz);
    }

    @Override
    public boolean exists() {
        return this.getClazz().getResource(this.getResolvedName()) != null;
    }

    @Override
    public ILocator getChild(String childName) {
        StringBuilder sb = new StringBuilder(this.getResolvedName());
        if (sb.length() > 1) {
            sb.append(SEPARATOR);
        }
        sb.append(childName);
        ClassResourceLocator result = new ClassResourceLocator(this.getClazz(), sb.toString());
        return result;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getClazz().getResourceAsStream(this.getResolvedName());
    }

    @Override
    public String getName() {
        if (this.resourceName == null) {
            return "unknown";
        }
        return PathTools.getName(this.resourceName);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.throwReadOnly();
        return null;
    }

    @Override
    public ILocator getParent() {
        int index = this.getResolvedName().lastIndexOf(SEPARATOR);
        if (SEPARATOR.equals(this.getResolvedName())) {
            return null;
        }
        if (index > -1) {
            String parentname = this.getResolvedName().substring(0, index);
            return new ClassResourceLocator(this.getClazz(), parentname);
        }
        return new ClassResourceLocator(this.getClazz(), "");
    }

    @Override
    public String getPath() {
        String file;
        URL localResourceURL = this.getResourceURL();
        if (localResourceURL != null && (file = localResourceURL.getFile()).length() > 0) {
            return file;
        }
        return this.getResolvedName();
    }

    @Override
    public synchronized IRandomAccess getRandomAccess() throws IOException {
        if (this.tempFileLocator == null) {
            this.tempFileLocator = this.createTempFileLocator();
        }
        return this.tempFileLocator.getRandomAccess();
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.getEncoding() == null) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getEncoding());
    }

    @Override
    public Reader getReader(String newEncoding) throws IOException {
        if (newEncoding == null || newEncoding.equals("")) {
            return this.getReader();
        }
        return new InputStreamReader(this.getInputStream(), newEncoding);
    }

    protected String getResolvedName() {
        return this.resolvedName;
    }

    protected String getResourceName() {
        return this.resourceName;
    }

    protected URL getResourceURL() {
        if (this.resourceURL == null) {
            this.resourceURL = this.getClass().getResource(this.getResolvedName());
        }
        return this.resourceURL;
    }

    @Override
    public Writer getWriter() throws IOException {
        this.throwReadOnly();
        return null;
    }

    @Override
    public Writer getWriter(String pEncoding) throws IOException {
        this.throwReadOnly();
        return null;
    }

    public int hashCode() {
        return this.resolvedName.hashCode();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        ArrayList result = new ArrayList();
        XFSScanner scanner = new XFSScanner(this.getClass().getClassLoader(), this.getResolvedName().substring(1), null);
        scanner.scan(found -> result.add(this.getChild(found.getName())));
        return result.toArray(new ILocator[result.size()]);
    }

    private String resolveName(String pName) {
        if (pName == null) {
            return pName;
        }
        if (!((String)pName).startsWith(SEPARATOR)) {
            Class<?> c = this.getClazz();
            while (c.isArray()) {
                c = c.getComponentType();
            }
            String baseName = c.getName();
            int index = baseName.lastIndexOf(46);
            pName = index != -1 ? SEPARATOR + baseName.substring(0, index).replace('.', '/') + SEPARATOR + (String)pName : SEPARATOR + (String)pName;
        }
        return pName;
    }

    protected void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void synch() {
    }

    public String toString() {
        URL url = this.getResourceURL();
        return url == null ? "<not found>#" + this.getResolvedName() : url.toString() + "#" + this.getResolvedName();
    }

    @Override
    public URI toURI() {
        return null;
    }
}

