/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.xfs.XFSScanner;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;

public class ClassLoaderResourceLocator
extends CommonLocator {
    private final ClassLoader classLoader;
    private final String resourceName;
    private URL resourceURL;
    private String encoding;
    private ILocator tempFileLocator;

    public ClassLoaderResourceLocator(ClassLoader classLoader, String path) {
        this.classLoader = classLoader;
        this.resourceName = path.replace("\\", "/");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassLoaderResourceLocator)) {
            return false;
        }
        return this.resourceName.equals(((ClassLoaderResourceLocator)obj).resourceName) && this.classLoader.equals(((ClassLoaderResourceLocator)obj).classLoader);
    }

    @Override
    public boolean exists() {
        return this.getClassLoader().getResource(this.getPath()) != null;
    }

    @Override
    public ILocator getChild(String childName) {
        StringBuilder sb = new StringBuilder(this.getPath());
        if (sb.length() > 0) {
            sb.append("/");
        }
        sb.append(childName);
        ClassLoaderResourceLocator result = new ClassLoaderResourceLocator(this.getClassLoader(), sb.toString());
        return result;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.getClassLoader().getResourceAsStream(this.getPath());
        if (is == null) {
            throw new FileNotFoundException("resource '" + this.getName() + "' not found");
        }
        return is;
    }

    @Override
    public long getLength() throws IOException {
        return this.getRandomAccess().getLength();
    }

    @Override
    public String getName() {
        if (this.resourceName == null) {
            return "unknown";
        }
        return PathTools.getName(this.resourceName);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.throwReadOnly();
        return null;
    }

    @Override
    public ILocator getParent() {
        int index = this.getPath().lastIndexOf("/");
        if (index > -1) {
            String parentname = this.getPath().substring(0, index);
            return new ClassLoaderResourceLocator(this.getClassLoader(), parentname);
        }
        if ("".equals(this.getPath())) {
            return null;
        }
        return new ClassLoaderResourceLocator(this.getClassLoader(), "");
    }

    @Override
    public String getPath() {
        return this.getResourceName();
    }

    @Override
    public synchronized IRandomAccess getRandomAccess() throws IOException {
        if (this.tempFileLocator == null) {
            this.tempFileLocator = this.createTempFileLocator();
        }
        return this.tempFileLocator.getRandomAccess();
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.getEncoding() == null) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getEncoding());
    }

    @Override
    public Reader getReader(String newEncoding) throws IOException {
        if (StringTools.isEmpty(newEncoding)) {
            return this.getReader();
        }
        return new InputStreamReader(this.getInputStream(), newEncoding);
    }

    protected String getResourceName() {
        return this.resourceName;
    }

    protected URL getResourceURL() {
        if (this.resourceURL == null) {
            this.resourceURL = this.getClassLoader().getResource(this.getPath());
        }
        return this.resourceURL;
    }

    @Override
    public Writer getWriter() throws IOException {
        this.throwReadOnly();
        return null;
    }

    @Override
    public Writer getWriter(String pEncoding) throws IOException {
        this.throwReadOnly();
        return null;
    }

    public int hashCode() {
        return this.resourceName.hashCode();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        ArrayList result = new ArrayList();
        XFSScanner scanner = new XFSScanner(this.getClassLoader(), this.getPath(), null);
        scanner.scan(found -> {
            if (filter == null || filter.accept(this, found.getName())) {
                result.add(this.getChild(found.getName()));
            }
        });
        return result.toArray(new ILocator[result.size()]);
    }

    protected void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void synch() {
    }

    public String toString() {
        URL url = this.getResourceURL();
        return url == null ? "<not found>" : url.toString() + "#" + this.getPath();
    }

    @Override
    public URI toURI() {
        return null;
    }
}

