/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.json;

import de.intarsys.tools.json.Json;
import de.intarsys.tools.json.JsonArray;
import de.intarsys.tools.json.JsonObject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class JsonWriter {
    private final Writer writer;

    public static void quote(String string, Writer w) throws IOException {
        if (string == null || string.length() == 0) {
            w.write("\"\"");
            return;
        }
        char c = '\u0000';
        int len = string.length();
        w.write(34);
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.write(92);
                    w.write(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        w.write(92);
                    }
                    w.write(c);
                    continue block9;
                }
                case '\b': {
                    w.write("\\b");
                    continue block9;
                }
                case '\t': {
                    w.write("\\t");
                    continue block9;
                }
                case '\n': {
                    w.write("\\n");
                    continue block9;
                }
                case '\f': {
                    w.write("\\f");
                    continue block9;
                }
                case '\r': {
                    w.write("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        w.write("\\u");
                        String hhhh = Integer.toHexString(c);
                        w.write("0000", 0, 4 - hhhh.length());
                        w.write(hhhh);
                        continue block9;
                    }
                    w.write(c);
                }
            }
        }
        w.write(34);
    }

    public static String toString(Object value, int indentFactor, int indent) throws IOException {
        StringWriter sw = new StringWriter();
        new JsonWriter(sw).write(value, indentFactor, indent);
        return sw.toString();
    }

    public JsonWriter(Writer w) {
        this.writer = w;
    }

    protected Writer getWriter() {
        return this.writer;
    }

    protected void indent(Writer writer, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            writer.write(32);
        }
    }

    public void write(Object value, int indentFactor, int indent) throws IOException {
        if (value == null) {
            this.getWriter().write("null");
        } else if (value instanceof JsonObject) {
            this.writeObject((JsonObject)value, indentFactor, indent);
        } else if (value instanceof Map) {
            this.writeMap((Map)value, indentFactor, indent);
        } else if (value instanceof JsonArray) {
            this.writeArray((JsonArray)value, indentFactor, indent);
        } else if (value instanceof Collection) {
            this.writeCollection((Collection)value, indentFactor, indent);
        } else if (value instanceof Number) {
            this.getWriter().write(Json.numberToString((Number)value));
        } else if (value instanceof Boolean) {
            this.getWriter().write(value.toString());
        } else {
            JsonWriter.quote(value.toString(), this.writer);
        }
    }

    protected void writeArray(JsonArray value, int indentFactor, int indent) throws IOException {
        boolean commanate = false;
        int length = value.size();
        this.writer.write(91);
        if (length == 1) {
            this.write(value.get(0), indentFactor, indent);
        } else if (length != 0) {
            int newindent = indent + indentFactor;
            Iterator<Object> it = value.iterator();
            while (it.hasNext()) {
                Object child = it.next();
                if (commanate) {
                    this.writer.write(44);
                }
                if (indentFactor > 0) {
                    this.writer.write(10);
                }
                this.indent(this.writer, newindent);
                this.write(child, indentFactor, newindent);
                commanate = true;
            }
            if (indentFactor > 0) {
                this.writer.write(10);
            }
            this.indent(this.writer, indent);
        }
        this.writer.write(93);
    }

    protected void writeCollection(Collection value, int indentFactor, int indent) throws IOException {
        boolean commanate = false;
        int length = value.size();
        this.writer.write(91);
        if (length == 1) {
            this.write(value.iterator().next(), indentFactor, indent);
        } else if (length != 0) {
            int newindent = indent + indentFactor;
            for (Object child : value) {
                if (commanate) {
                    this.writer.write(44);
                }
                if (indentFactor > 0) {
                    this.writer.write(10);
                }
                this.indent(this.writer, newindent);
                this.write(child, indentFactor, newindent);
                commanate = true;
            }
            if (indentFactor > 0) {
                this.writer.write(10);
            }
            this.indent(this.writer, indent);
        }
        this.writer.write(93);
    }

    protected void writeMap(Map value, int indentFactor, int indent) throws IOException {
        boolean commanate = false;
        int length = value.size();
        Iterator itNames = value.keySet().iterator();
        this.writer.write(123);
        if (length == 1) {
            String key = (String)itNames.next();
            this.writer.write(Json.quote(key));
            this.writer.write(58);
            if (indentFactor > 0) {
                this.writer.write(32);
            }
            this.write(value.get(key), indentFactor, indent);
        } else if (length != 0) {
            int newindent = indent + indentFactor;
            while (itNames.hasNext()) {
                String key = (String)itNames.next();
                if (commanate) {
                    this.writer.write(44);
                }
                if (indentFactor > 0) {
                    this.writer.write(10);
                }
                this.indent(this.writer, newindent);
                this.writer.write(Json.quote(key));
                this.writer.write(58);
                if (indentFactor > 0) {
                    this.writer.write(32);
                }
                this.write(value.get(key), indentFactor, newindent);
                commanate = true;
            }
            if (indentFactor > 0) {
                this.writer.write(10);
            }
            this.indent(this.writer, indent);
        }
        this.writer.write(125);
    }

    protected void writeObject(JsonObject value, int indentFactor, int indent) throws IOException {
        boolean commanate = false;
        int length = value.size();
        Iterator<String> itNames = value.names().iterator();
        this.writer.write(123);
        if (length == 1) {
            String key = itNames.next();
            this.writer.write(Json.quote(key));
            this.writer.write(58);
            if (indentFactor > 0) {
                this.writer.write(32);
            }
            this.write(value.get(key), indentFactor, indent);
        } else if (length != 0) {
            int newindent = indent + indentFactor;
            while (itNames.hasNext()) {
                String key = itNames.next();
                if (commanate) {
                    this.writer.write(44);
                }
                if (indentFactor > 0) {
                    this.writer.write(10);
                }
                this.indent(this.writer, newindent);
                this.writer.write(Json.quote(key));
                this.writer.write(58);
                if (indentFactor > 0) {
                    this.writer.write(32);
                }
                this.write(value.get(key), indentFactor, newindent);
                commanate = true;
            }
            if (indentFactor > 0) {
                this.writer.write(10);
            }
            this.indent(this.writer, indent);
        }
        this.writer.write(125);
    }
}

