/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.json;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.json.Json;
import de.intarsys.tools.json.JsonArray;
import de.intarsys.tools.json.JsonWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JsonObject {
    private final Map<String, Object> map = new HashMap<String, Object>();

    protected JsonObject() {
    }

    protected JsonObject basicPut(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    public void clear() {
        this.map.clear();
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public boolean getBoolean(String key) throws ConversionException {
        Object object = this.get(key);
        return Json.toBoolean(object);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double getDouble(String key) throws ConversionException {
        Object object = this.get(key);
        return Json.toDouble(object);
    }

    public double getDouble(String key, double defaultValue) {
        try {
            return this.getDouble(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getInt(String key) throws ConversionException {
        Object object = this.get(key);
        return Json.toInt(object);
    }

    public int getInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JsonArray getJSONArray(String key) throws ConversionException {
        Object object = this.get(key);
        if (object instanceof JsonArray) {
            return (JsonArray)object;
        }
        throw new ConversionException("not a JSONArray.");
    }

    public JsonArray getJSONArray(String key, JsonArray defaultValue) {
        Object o = this.get(key);
        return o instanceof JsonArray ? (JsonArray)o : defaultValue;
    }

    public JsonObject getJSONObject(String key) throws ConversionException {
        Object object = this.get(key);
        if (object instanceof JsonObject) {
            return (JsonObject)object;
        }
        throw new ConversionException("not a JSONObject.");
    }

    public JsonObject getJSONObject(String key, JsonObject defaultValue) {
        Object object = this.map.get(key);
        return object instanceof JsonObject ? (JsonObject)object : defaultValue;
    }

    public long getLong(String key) throws ConversionException {
        Object object = this.get(key);
        return Json.toLong(object);
    }

    public long getLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getString(String key) throws ConversionException {
        Object object = this.get(key);
        return Json.toString(object);
    }

    public String getString(String key, String defaultValue) {
        try {
            return this.getString(key);
        }
        catch (ConversionException e) {
            return defaultValue;
        }
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public Set<String> names() {
        return this.map.keySet();
    }

    public JsonObject put(String key, boolean value) {
        return this.basicPut(key, value);
    }

    public JsonObject put(String key, double value) {
        return this.basicPut(key, value);
    }

    public JsonObject put(String key, int value) {
        return this.basicPut(key, value);
    }

    public JsonObject put(String key, JsonArray value) {
        return this.basicPut(key, value);
    }

    public JsonObject put(String key, JsonObject value) {
        return this.basicPut(key, value);
    }

    public JsonObject put(String key, long value) {
        return this.basicPut(key, value);
    }

    public JsonObject put(String key, String value) {
        return this.basicPut(key, value);
    }

    public JsonObject remove(String key) {
        this.map.remove(key);
        return this;
    }

    public int size() {
        return this.map.size();
    }

    public Map toJava() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            result.put(entry.getKey(), Json.toJava(entry.getValue()));
        }
        return result;
    }

    public String toString() {
        try {
            return this.toString(0);
        }
        catch (Exception e) {
            return "<unprintable>";
        }
    }

    public String toString(int indentFactor) {
        StringWriter w = new StringWriter();
        try {
            new JsonWriter(w).write(this, indentFactor, 0);
            return w.toString();
        }
        catch (Exception e) {
            return "<unprintable>";
        }
    }
}

