/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.json;

import de.intarsys.tools.collection.IterableTools;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.json.JsonArray;
import de.intarsys.tools.json.JsonObject;
import de.intarsys.tools.json.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class Json {
    public static JsonArray copy(JsonArray array) {
        JsonArray copy = Json.createArray();
        for (Object value : IterableTools.in(array.iterator())) {
            value = Json.copy(value);
            copy.basicAdd(value);
        }
        return copy;
    }

    public static JsonObject copy(JsonObject object) {
        JsonObject copy = Json.createObject();
        for (String name : object.names()) {
            Object value = object.get(name);
            value = Json.copy(value);
            copy.basicPut(name, value);
        }
        return copy;
    }

    public static Object copy(Object jsonObject) {
        if (jsonObject instanceof JsonObject) {
            return Json.copy((JsonObject)jsonObject);
        }
        if (jsonObject instanceof JsonArray) {
            return Json.copy((JsonArray)jsonObject);
        }
        return jsonObject;
    }

    public static JsonArray createArray() {
        JsonArray result = new JsonArray();
        return result;
    }

    public static JsonArray createArray(Collection collection) {
        JsonArray result = new JsonArray();
        if (collection != null) {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                result.basicAdd(Json.wrap(iter.next()));
            }
        }
        return result;
    }

    public static JsonObject createObject() {
        JsonObject result = new JsonObject();
        return result;
    }

    public static JsonObject createObject(Map<String, Object> map) {
        JsonObject result = new JsonObject();
        if (map != null) {
            for (Map.Entry<String, Object> e : map.entrySet()) {
                Object value = e.getValue();
                if (value == null) continue;
                result.basicPut(e.getKey(), Json.wrap(value));
            }
        }
        return result;
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String string = Double.toString(d);
        if (string.indexOf(46) >= 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.length() == 0) {
                return "0";
            }
        }
        return string;
    }

    public static boolean isJson(String value) {
        return Json.startsWith(value, "{[");
    }

    public static boolean isJsonArray(String value) {
        return Json.startsWith(value, "[");
    }

    public static boolean isJsonObject(String value) {
        return Json.startsWith(value, "{");
    }

    public static String numberToString(Number number) {
        String string = number.toString();
        if (string.indexOf(46) >= 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.length() == 0) {
                return "0";
            }
        }
        return string;
    }

    public static String quote(String string) {
        StringWriter w = new StringWriter();
        try {
            JsonWriter.quote(string, w);
            return w.toString();
        }
        catch (IOException ignored) {
            return "";
        }
    }

    protected static boolean startsWith(String value, String chars) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return chars.indexOf(value.charAt(i)) >= 0;
        }
        return false;
    }

    public static boolean toBoolean(Object object) throws ConversionException {
        if (object != null) {
            if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
                return false;
            }
            if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
                return true;
            }
        }
        throw new ConversionException("not a boolean.");
    }

    public static double toDouble(Object object) throws ConversionException {
        try {
            if (object != null) {
                if (object instanceof Number) {
                    return ((Number)object).doubleValue();
                }
                if (object instanceof String) {
                    return Double.parseDouble((String)object);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ConversionException("not a double");
    }

    public static int toInt(Object object) throws ConversionException {
        try {
            if (object != null) {
                if (object instanceof Number) {
                    return ((Number)object).intValue();
                }
                if (object instanceof String) {
                    return Integer.parseInt((String)object);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ConversionException("not an int");
    }

    public static Object toJava(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JsonObject) {
            return ((JsonObject)value).toJava();
        }
        if (value instanceof JsonArray) {
            return ((JsonArray)value).toJava();
        }
        return value;
    }

    public static long toLong(Object object) throws ConversionException {
        try {
            if (object != null) {
                if (object instanceof Number) {
                    return ((Number)object).longValue();
                }
                if (object instanceof String) {
                    return Long.parseLong((String)object);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ConversionException("not an int");
    }

    public static String toString(Object object) throws ConversionException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public static String valueToString(Object value) throws IOException {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number) {
            return Json.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JsonObject || value instanceof JsonArray) {
            return value.toString();
        }
        return Json.quote(value.toString());
    }

    public static Object wrap(Object object) {
        try {
            if (object == null) {
                return null;
            }
            if (object instanceof JsonObject || object instanceof JsonArray || object instanceof Number || object instanceof Boolean || object instanceof String) {
                return object;
            }
            if (object instanceof Collection) {
                return Json.createArray((Collection)object);
            }
            if (object instanceof Map) {
                return Json.createObject((Map)object);
            }
            return object.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Json() {
    }
}

