/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

import de.intarsys.tools.infoset.StandardDocument;
import de.intarsys.tools.infoset.StandardElement;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StandardContentHandler
extends DefaultHandler {
    private StringBuilder sb = new StringBuilder();
    private StandardDocument document;
    private StandardElement element;
    private Locator documentLocator;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.sb.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.element != null) {
            throw new SAXException("document has open elements");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.element.setText(this.sb.toString());
        this.sb.setLength(0);
        this.element = this.element.getParent();
    }

    public StandardDocument getDocument() {
        return this.document;
    }

    public Locator getDocumentLocator() {
        return this.documentLocator;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.documentLocator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.document = new StandardDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        StandardElement parent = this.element;
        if (parent == null) {
            this.element = new StandardElement(this.document, parent, qName, false);
            this.document.setRootElement(this.element);
        } else {
            this.element = (StandardElement)parent.newElementMapped(qName);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.element.newAttribute(attributes.getQName(i)).setRaw(attributes.getValue(i));
        }
        this.sb.setLength(0);
    }
}

