/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

public class OutputFormat {
    protected static final String STANDARD_INDENT = "  ";
    private boolean escapeText = true;
    private boolean suppressDeclaration;
    private boolean newLineAfterDeclaration = true;
    private String encoding = "UTF-8";
    private boolean omitEncoding;
    private String indent;
    private boolean expandEmptyElements;
    private boolean newlines;
    private String lineSeparator = "\n";
    private boolean trimText;
    private boolean doXHTML;
    private int newLineAfterNTags;
    private char attributeQuoteChar = (char)34;

    public static OutputFormat createCompactFormat() {
        OutputFormat format = new OutputFormat();
        format.setIndent(false);
        format.setNewlines(false);
        format.setTrimText(true);
        return format;
    }

    public static OutputFormat createPrettyPrint() {
        OutputFormat format = new OutputFormat();
        format.setIndentSize(2);
        format.setNewlines(true);
        format.setTrimText(true);
        return format;
    }

    public OutputFormat() {
    }

    public OutputFormat(String indent) {
        this.indent = indent;
    }

    public OutputFormat(String indent, boolean newlines) {
        this.indent = indent;
        this.newlines = newlines;
    }

    public OutputFormat(String indent, boolean newlines, String encoding) {
        this.indent = indent;
        this.newlines = newlines;
        this.encoding = encoding;
    }

    public char getAttributeQuoteCharacter() {
        return this.attributeQuoteChar;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getIndent() {
        return this.indent;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public int getNewLineAfterNTags() {
        return this.newLineAfterNTags;
    }

    public boolean isEscapeText() {
        return this.escapeText;
    }

    public boolean isExpandEmptyElements() {
        return this.expandEmptyElements;
    }

    public boolean isNewLineAfterDeclaration() {
        return this.newLineAfterDeclaration;
    }

    public boolean isNewlines() {
        return this.newlines;
    }

    public boolean isOmitEncoding() {
        return this.omitEncoding;
    }

    public boolean isSuppressDeclaration() {
        return this.suppressDeclaration;
    }

    public boolean isTrimText() {
        return this.trimText;
    }

    public boolean isXHTML() {
        return this.doXHTML;
    }

    public void setAttributeQuoteCharacter(char quoteChar) {
        if (quoteChar != '\'' && quoteChar != '\"') {
            throw new IllegalArgumentException("Invalid attribute quote character (" + quoteChar + ")");
        }
        this.attributeQuoteChar = quoteChar;
    }

    public void setEncoding(String encoding) {
        if (encoding != null) {
            this.encoding = encoding;
        }
    }

    public void setEscapeText(boolean escapeText) {
        this.escapeText = escapeText;
    }

    public void setExpandEmptyElements(boolean expandEmptyElements) {
        this.expandEmptyElements = expandEmptyElements;
    }

    public void setIndent(boolean doIndent) {
        this.indent = doIndent ? STANDARD_INDENT : null;
    }

    public void setIndent(String indent) {
        if (indent != null && indent.length() <= 0) {
            indent = null;
        }
        this.indent = indent;
    }

    public void setIndentSize(int indentSize) {
        StringBuilder indentBuffer = new StringBuilder();
        for (int i = 0; i < indentSize; ++i) {
            indentBuffer.append(" ");
        }
        this.indent = indentBuffer.toString();
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public void setNewLineAfterDeclaration(boolean newLineAfterDeclaration) {
        this.newLineAfterDeclaration = newLineAfterDeclaration;
    }

    public void setNewLineAfterNTags(int tagCount) {
        this.newLineAfterNTags = tagCount;
    }

    public void setNewlines(boolean newlines) {
        this.newlines = newlines;
    }

    public void setOmitEncoding(boolean omitEncoding) {
        this.omitEncoding = omitEncoding;
    }

    public void setSuppressDeclaration(boolean suppressDeclaration) {
        this.suppressDeclaration = suppressDeclaration;
    }

    public void setTrimText(boolean trimText) {
        this.trimText = trimText;
    }

    public void setXHTML(boolean xhtml) {
        this.doXHTML = xhtml;
    }
}

