/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.AbstractElement;
import de.intarsys.tools.infoset.ArgsAttributeAdapter;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.infoset.INode;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class ArgsElementAdapter
extends AbstractElement {
    private final IArgs args;
    private final String name;

    public ArgsElementAdapter(IArgs args) {
        this("root", args);
    }

    public ArgsElementAdapter(String name, IArgs args) {
        this(name, args, !args.isNamed());
    }

    protected ArgsElementAdapter(String name, IArgs args, boolean indexed) {
        super(indexed);
        this.name = name;
        this.args = args;
    }

    protected IAttribute asAttribute(String name, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof IArgs) {
            return null;
        }
        if (value instanceof IElementSerializable) {
            IElementSerializable serializable = (IElementSerializable)value;
            return null;
        }
        return new ArgsAttributeAdapter(this, name);
    }

    protected IElement asElement(String name, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof IArgs) {
            IArgs vArgs = (IArgs)value;
            return new ArgsElementAdapter(name, vArgs);
        }
        if (value instanceof IElementSerializable) {
            IElementSerializable serializable = (IElementSerializable)value;
            IElement childElement = ElementFactory.get().createElement(name);
            try {
                serializable.serialize(childElement);
            }
            catch (ElementSerializationException elementSerializationException) {
                // empty catch block
            }
            return childElement;
        }
        return null;
    }

    protected INode asNode(String name, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof IArgs) {
            IArgs args = (IArgs)value;
            return new ArgsElementAdapter(name, args);
        }
        if (value instanceof IElementSerializable) {
            IElementSerializable serializable = (IElementSerializable)value;
            IElement childElement = ElementFactory.get().createElement(name);
            try {
                serializable.serialize(childElement);
            }
            catch (ElementSerializationException elementSerializationException) {
                // empty catch block
            }
            return childElement;
        }
        return new ArgsAttributeAdapter(this, name);
    }

    @Override
    public IAttribute attribute(String name) {
        Object value = this.args.get(name);
        return this.asAttribute(name, value);
    }

    @Override
    public Iterator<IAttribute> attributeIterator() {
        return new Iterator<IAttribute>(){
            Iterator<IArgs.IBinding> iterator;
            IAttribute attribute;
            {
                this.iterator = ArgsElementAdapter.this.args.bindings();
            }

            @Override
            public boolean hasNext() {
                while (this.attribute == null && this.iterator.hasNext()) {
                    IArgs.IBinding current = this.iterator.next();
                    this.attribute = ArgsElementAdapter.this.asAttribute(current.getName(), current.getValue());
                }
                return this.attribute != null;
            }

            @Override
            public IAttribute next() {
                if (this.hasNext()) {
                    try {
                        IAttribute iAttribute = this.attribute;
                        return iAttribute;
                    }
                    finally {
                        this.attribute = null;
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public Iterator<String> attributeNames() {
        return new Iterator<String>(){
            Iterator<IArgs.IBinding> iterator;
            IAttribute attribute;
            {
                this.iterator = ArgsElementAdapter.this.args.bindings();
            }

            @Override
            public boolean hasNext() {
                while (this.attribute == null && this.iterator.hasNext()) {
                    IArgs.IBinding current = this.iterator.next();
                    this.attribute = ArgsElementAdapter.this.asAttribute(current.getName(), current.getValue());
                }
                return this.attribute != null;
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    try {
                        String string = this.attribute.getName();
                        return string;
                    }
                    finally {
                        this.attribute = null;
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    protected Object basicGetAttributeData(IAttribute attribute, String name) {
        return this.args.get(name);
    }

    @Override
    protected Object basicGetAttributeRaw(IAttribute abstractAttribute, String name) {
        return this.args.get(name);
    }

    @Override
    protected String basicGetAttributeValue(IAttribute attribute, String name) {
        return this.toString(this.basicGetAttributeData(attribute, name));
    }

    @Override
    protected void basicSetAttributeData(IAttribute attribute, String name, Object data) {
        this.args.put(name, data);
    }

    @Override
    protected void basicSetAttributeRaw(IAttribute abstractAttribute, String name, Object raw) {
        this.args.put(name, raw);
    }

    @Override
    protected void basicSetAttributeValue(IAttribute attribute, String name, String value) {
        this.args.put(name, (Object)value);
    }

    @Override
    public IElement element(String name) {
        Object value = this.args.get(name);
        return this.asElement(name, value);
    }

    @Override
    public Iterator<IElement> elementIterator() {
        return new Iterator<IElement>(){
            Iterator<IArgs.IBinding> iterator;
            IElement element;
            {
                this.iterator = ArgsElementAdapter.this.args.bindings();
            }

            @Override
            public boolean hasNext() {
                while (this.element == null && this.iterator.hasNext()) {
                    IArgs.IBinding current = this.iterator.next();
                    this.element = ArgsElementAdapter.this.asElement(current.getName(), current.getValue());
                }
                return this.element != null;
            }

            @Override
            public IElement next() {
                if (this.hasNext()) {
                    try {
                        IElement iElement = this.element;
                        return iElement;
                    }
                    finally {
                        this.element = null;
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    public IArgs getArgs() {
        return this.args;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IAttribute newAttribute(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        this.args.put(name, (Object)"");
        return new ArgsAttributeAdapter(this, name);
    }

    @Override
    public IElement newElementIndexed(String name) {
        Args newArgs = Args.createIndexed();
        if (this.isIndexed()) {
            this.args.add(newArgs);
        } else {
            Objects.requireNonNull(name, "name cannot be null");
            this.args.put(name, (Object)newArgs);
        }
        return new ArgsElementAdapter(name, newArgs, true);
    }

    @Override
    public IElement newElementMapped(String name) {
        Args newArgs = Args.create();
        if (this.isIndexed()) {
            this.args.add(newArgs);
        } else {
            Objects.requireNonNull(name, "name cannot be null");
            this.args.put(name, (Object)newArgs);
        }
        return new ArgsElementAdapter(name, newArgs, false);
    }

    @Override
    public INode node(String name) {
        Object value = this.args.get(name);
        return this.asNode(name, value);
    }

    @Override
    public Iterator<INode> nodeIterator() {
        return new Iterator<INode>(){
            Iterator<IArgs.IBinding> iterator;
            INode node;
            {
                this.iterator = ArgsElementAdapter.this.args.bindings();
            }

            @Override
            public boolean hasNext() {
                while (this.node == null && this.iterator.hasNext()) {
                    IArgs.IBinding current = this.iterator.next();
                    this.node = ArgsElementAdapter.this.asNode(current.getName(), current.getValue());
                }
                return this.node != null;
            }

            @Override
            public INode next() {
                if (this.hasNext()) {
                    try {
                        INode iNode = this.node;
                        return iNode;
                    }
                    finally {
                        this.node = null;
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public void nodeRemove(String name) {
        this.args.undefine(name);
    }

    @Override
    public void setAttributeData(String name, Object value) {
        Objects.requireNonNull(name, "name cannot be null");
        this.args.put(name, value);
    }

    @Override
    public void setAttributeValue(String name, String value) {
        Objects.requireNonNull(name, "name cannot be null");
        this.args.put(name, (Object)value);
    }
}

