/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.Declaration;
import de.intarsys.tools.functor.IDeclaration;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IDeclarationElement;

public class DeclarationBlock
extends Declaration
implements IDeclarationBlock {
    private IDeclarationElement[] declarations;

    public DeclarationBlock(Object declarationContext) {
        super(declarationContext);
        this.declarations = new IDeclarationElement[0];
    }

    public DeclarationBlock(Object declarationContext, IDeclarationElement[] declarations) {
        super(declarationContext);
        if (declarations == null) {
            throw new IllegalArgumentException("declarations can't be null");
        }
        this.declarations = declarations;
    }

    @Override
    public void addDeclarationElement(IDeclarationElement pDeclaration) {
        for (int i = 0; i < this.declarations.length; ++i) {
            IDeclarationElement declaration = this.declarations[i];
            if (!declaration.getName().equals(pDeclaration.getName())) continue;
            this.declarations[i] = pDeclaration;
            return;
        }
        IDeclarationElement[] newDeclarations = new IDeclarationElement[this.declarations.length + 1];
        System.arraycopy(this.declarations, 0, newDeclarations, 0, this.declarations.length);
        newDeclarations[this.declarations.length] = pDeclaration;
        this.declarations = newDeclarations;
    }

    @Override
    public void clear() {
        if (this.declarations.length == 0) {
            return;
        }
        this.declarations = new IDeclarationElement[0];
    }

    @Override
    public IDeclaration copy() {
        IDeclarationElement[] copyDeclarations = new IDeclarationElement[this.size()];
        for (int i = 0; i < this.declarations.length; ++i) {
            IDeclarationElement declaration = this.declarations[i];
            copyDeclarations[i] = (IDeclarationElement)declaration.copy();
        }
        return new DeclarationBlock(this.getDeclarationContext(), copyDeclarations);
    }

    @Override
    public IDeclarationElement getDeclarationElement(String name) {
        for (int i = 0; i < this.declarations.length; ++i) {
            IDeclarationElement declaration = this.declarations[i];
            if (!declaration.getName().equals(name)) continue;
            return declaration;
        }
        return null;
    }

    @Override
    public IDeclarationElement[] getDeclarationElements() {
        return this.declarations;
    }

    @Override
    public boolean isBlock() {
        return true;
    }

    @Override
    public void moveDown(IDeclarationElement declaration) {
        for (int i = 0; i < this.declarations.length - 1; ++i) {
            if (this.declarations[i] != declaration) continue;
            this.declarations[i] = this.declarations[i + 1];
            this.declarations[i + 1] = declaration;
            break;
        }
    }

    @Override
    public void moveUp(IDeclarationElement declaration) {
        for (int i = 1; i < this.declarations.length; ++i) {
            if (this.declarations[i] != declaration) continue;
            this.declarations[i] = this.declarations[i - 1];
            this.declarations[i - 1] = declaration;
            break;
        }
    }

    @Override
    public boolean removeDeclarationElement(IDeclarationElement declaration) {
        for (int i = 0; i < this.declarations.length; ++i) {
            if (this.declarations[i] != declaration) continue;
            IDeclarationElement[] newDeclarations = new IDeclarationElement[this.declarations.length - 1];
            System.arraycopy(this.declarations, 0, newDeclarations, 0, i);
            System.arraycopy(this.declarations, i + 1, newDeclarations, i, this.declarations.length - i - 1);
            this.declarations = newDeclarations;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.declarations.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IDeclarationElement element : this.declarations) {
            sb.append(element.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

