/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ArgsCryptoBase {
    public static final String ARG_VERSION = "version";
    public static final String ARG_TYPE = "type";
    public static final String ARG_VALUE = "value";
    public static final String ARG_RAW = "raw";
    public static final String ARG_SIGNER = "signer";
    public static final String ARG_SIGNED = "signed";
    public static final String ARG_CONTENT = "content";
    public static final String ARG_CERTIFICATES = "certificates";
    public static final String ARG_HASH = "hash";
    public static final String ARG_SELECT = "select";
    public static final String ARG_ALGORITHM = "algorithm";
    public static final String VERSION_1_0 = "1.0";
    public static final String TYPE_ARGDSIG = "ArgDSig";
    public static final String DEFAULT_DIGEST_ALGORITHM = "SHA-256";
    public static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA256withRSA";
    public static final String DEFAULT_CERTIFICATE_TYPE = "X.509";
    protected static final List<String> DEFAULT_SELECT = ListTools.with("*", "!signature");

    protected ArgsCryptoBase() {
    }

    protected IArgs createSignedContentArgs(IArgs args, List<String> fields) {
        Args signedContent = Args.create();
        for (String field : fields) {
            this.updateSubtree(signedContent, args, field);
        }
        return signedContent;
    }

    protected byte[] hash(String hashAlgorithm, IArgs args) throws GeneralSecurityException {
        final MessageDigest digest = MessageDigest.getInstance(hashAlgorithm);
        OutputStream os = new OutputStream(){

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                digest.update(b, off, len);
            }

            @Override
            public void write(int b) throws IOException {
                digest.update((byte)b);
            }
        };
        try {
            this.writeArgs(os, args);
        }
        catch (IOException e) {
            throw ExceptionTools.getCause(e, GeneralSecurityException.class);
        }
        return digest.digest();
    }

    protected void updateSignature(final Signature signature, IArgs args) throws GeneralSecurityException {
        OutputStream os = new OutputStream(){

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                try {
                    signature.update(b, off, len);
                }
                catch (SignatureException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public void write(int b) throws IOException {
                try {
                    signature.update((byte)b);
                }
                catch (SignatureException e) {
                    throw new IOException(e);
                }
            }
        };
        try {
            this.writeArgs(os, args);
        }
        catch (IOException e) {
            throw ExceptionTools.getCause(e, GeneralSecurityException.class);
        }
    }

    protected void updateSubtree(IArgs subtree, IArgs args, String field) {
        if ("*".equals(field)) {
            ArgTools.putAll(subtree, args);
        } else if (field.startsWith("!")) {
            field = field.substring(1);
            ArgTools.undefinePath(subtree, field);
        } else {
            Object value = ArgTools.getObject(args, field, null);
            ArgTools.putPath(subtree, field, value);
        }
    }

    protected void writeArg(OutputStream os, String key, Object value) throws IOException {
        os.write(key.getBytes(StandardCharsets.UTF_8));
        os.write("=".getBytes(StandardCharsets.UTF_8));
        if (value instanceof IArgs) {
            os.write("{\n".getBytes(StandardCharsets.UTF_8));
            this.writeArgs(os, (IArgs)value);
            os.write("\n}".getBytes(StandardCharsets.UTF_8));
        } else {
            String string = String.valueOf(value);
            os.write(string.getBytes(StandardCharsets.UTF_8));
        }
        os.write("\n".getBytes(StandardCharsets.UTF_8));
    }

    protected void writeArgs(OutputStream os, IArgs args) throws IOException {
        ArrayList<String> names = new ArrayList<String>(args.names());
        if (names.isEmpty()) {
            for (int i = 0; i < args.size(); ++i) {
                String key = "" + i;
                Object value = args.get(i);
                this.writeArg(os, key, value);
            }
        } else {
            Collections.sort(names);
            for (String name : names) {
                if (!args.isDefined(name)) continue;
                String key = name;
                Object value = args.get(name);
                this.writeArg(os, key, value);
            }
        }
    }
}

