/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.category.CategoryRegistry;
import de.intarsys.tools.category.ICategory;
import de.intarsys.tools.category.ICategorySupport;
import de.intarsys.tools.category.StandardCategoryRegistry;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.environment.file.IFileEnvironment;
import de.intarsys.tools.event.CreatedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.factory.BasicFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.ILocatorFactorySupport;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.NullPreferences;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.presentation.PresentationMixin;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.tag.TagTools;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;

public abstract class CommonFactory<T>
extends BasicFactory<T>
implements IPresentationSupport,
IElementConfigurable,
ILocatorFactorySupport,
IFileEnvironment,
ICategorySupport,
IAttributeSupport,
INotificationSupport,
IPreferencesSyncher,
IPreferencesSupport {
    public static final String ARG_CONFIGURATION = "configuration";
    public static final String ARG_CONTEXT = "context";
    public static final String ARG_CLASSLOADER = "classLoader";
    private final EventDispatcher dispatcher = new EventDispatcher(this);
    private ICategory category;
    private IElement configuration;
    private final AttributeMap attributes = new AttributeMap();
    private IPreferences preferences;
    private String preferencesName;
    private final PresentationMixin presentation = new PresentationMixin(this);
    private final ILocatorFactory locatorFactoryFacade = new ILocatorFactory(){

        @Override
        public ILocator createLocator(String location) throws IOException {
            return CommonFactory.this.basicCreateLocator(location);
        }
    };

    protected CommonFactory() {
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    protected ILocator basicCreateLocator(String location) throws IOException {
        ILocatorFactory resultFactory = LocatorTools.createLookupFactory(this.getContext());
        return resultFactory.createLocator(location);
    }

    @Override
    protected void basicStop() {
        super.basicStop();
        this.preferencesStore();
    }

    @Override
    public void configure(IElement pElement) throws ConfigurationException {
        this.configuration = pElement;
        String tempId = this.configuration.attributeValue("id", null);
        if (tempId != null) {
            this.setId(tempId);
        }
        this.presentation.configure(this.configuration);
        TagTools.configureTags(this, this.configuration);
        this.setPreferencesName(this.configuration.attributeValue("preferences", null));
    }

    public ILocator createLocatorGlobal(String name) throws IOException {
        ILocatorFactory locatorFactory = LocatorTools.createLookupFactory(this.getContext(), LocatorFactory.get());
        return locatorFactory.createLocator(name);
    }

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        if (StringTools.isEmpty(name)) {
            return NullPreferences.ACTIVE;
        }
        IPreferences root = PreferencesFactory.get().getRoot();
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        IPreferences result = root.node(name);
        IPreferences defaultPreferences = result.restrict("DEFAULT");
        this.preferencesInit(defaultPreferences);
        return result;
    }

    @Override
    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    @Override
    public File getBaseDir() {
        return this.getFileEnvironment().getBaseDir();
    }

    @Override
    public ICategory getCategory() {
        if (this.category == null) {
            String categoryId = this.configuration.attributeValue("category", null);
            this.setCategory(CategoryRegistry.get().lookupCategory(categoryId));
            if (this.category == null) {
                this.setCategory(StandardCategoryRegistry.UNKNOWN);
            }
        }
        return this.category;
    }

    protected ClassLoader getClassLoader(IArgs args) {
        Object result = args.get(ARG_CLASSLOADER);
        return result instanceof ClassLoader ? (ClassLoader)result : this.getClassLoader();
    }

    protected IElement getConfiguration() {
        return this.configuration;
    }

    protected IElement getConfiguration(IArgs args) {
        Object result = args.get(ARG_CONFIGURATION);
        return result instanceof IElement ? (IElement)result : null;
    }

    protected Object getContext(IArgs args) {
        Object result = args.get(ARG_CONTEXT);
        return result == null ? this.getContext() : result;
    }

    @Override
    public File getDataDir() {
        return this.getFileEnvironment().getDataDir();
    }

    @Override
    public String getDescription() {
        return this.presentation.getDescription();
    }

    protected EventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    protected IFileEnvironment getFileEnvironment() {
        if (this.getContext() instanceof IFileEnvironment) {
            return (IFileEnvironment)this.getContext();
        }
        return FileEnvironment.get();
    }

    @Override
    public String getIconName() {
        return this.presentation.getIconName();
    }

    @Override
    public String getLabel() {
        return this.presentation.getLabel();
    }

    @Override
    public ILocatorFactory getLocatorFactory() {
        return this.locatorFactoryFacade;
    }

    @Override
    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return this.preferencesName;
    }

    @Override
    public File getProfileDir() {
        return this.getFileEnvironment().getProfileDir();
    }

    @Override
    public File getTempDir() {
        return this.getFileEnvironment().getTempDir();
    }

    @Override
    public String getTip() {
        return this.presentation.getTip();
    }

    @Override
    public File getWorkingDir() {
        return this.getFileEnvironment().getWorkingDir();
    }

    protected void preferencesInit(IPreferences preferences) {
    }

    @Override
    @PostConstruct
    public final void preferencesRestore() {
        this.preferencesRestore(this.getPreferences());
    }

    protected void preferencesRestore(IPreferences preferences) {
    }

    @Override
    public final void preferencesStore() {
        this.preferencesStore(this.getPreferences());
    }

    protected void preferencesStore(IPreferences preferences) {
    }

    @Override
    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void setCategory(ICategory category) {
        this.category = category;
    }

    protected void setPreferences(IPreferences preferences) {
        this.preferences = preferences;
    }

    protected void setPreferencesName(String preferencesName) {
        this.preferencesName = preferencesName;
    }

    public String toString() {
        return "factory " + this.getId();
    }

    protected void triggerCreated(Object result) {
        CreatedEvent event = new CreatedEvent(this);
        event.setInstance(result);
        this.triggerEvent(event);
    }

    protected void triggerEvent(Event event) {
        this.dispatcher.triggerEvent(event);
    }
}

