/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.event.StartedEvent;
import de.intarsys.tools.event.StopRequestedEvent;
import de.intarsys.tools.event.StoppedEvent;
import de.intarsys.tools.factory.CanonicalFromFactoryConverter;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.reflect.IClassLoaderSupport;
import java.util.Set;

public abstract class BasicFactory<T>
implements IFactory<T>,
IContextSupport,
IClassLoaderSupport,
IStartStop {
    private String id;
    private Object context;
    protected final Object lock = new Object();
    private boolean started;
    private final INotificationListener<StartedEvent> listenContextStarted = new INotificationListener<StartedEvent>(){

        @Override
        public void handleEvent(StartedEvent event) {
            BasicFactory.this.basicStart();
        }
    };
    private final INotificationListener<StoppedEvent> listenContextStopped = new INotificationListener<StoppedEvent>(){

        @Override
        public void handleEvent(StoppedEvent event) {
            BasicFactory.this.basicStop();
        }
    };
    private final INotificationListener<StopRequestedEvent> listenContextStopRequested = new INotificationListener<StopRequestedEvent>(){

        @Override
        public void handleEvent(StopRequestedEvent event) {
            if (!BasicFactory.this.basicStopRequested(event.getVisited())) {
                event.veto();
            }
        }
    };

    protected void basicStart() {
    }

    protected void basicStop() {
    }

    protected boolean basicStopRequested(Set visited) {
        return true;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.getContext() instanceof IClassLoaderSupport) {
            return ((IClassLoaderSupport)this.getContext()).getClassLoader();
        }
        return this.getDefaultClassLoader();
    }

    public Object getContext() {
        return this.context;
    }

    protected ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected String getDefaultId() {
        return this.getClass().getName();
    }

    @Override
    public String getId() {
        if (this.id == null) {
            return this.getDefaultId();
        }
        return this.id;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void setContext(Object context) throws ConfigurationException {
        this.context = context;
        if (context instanceof INotificationSupport) {
            ((INotificationSupport)context).addNotificationListener(StartedEvent.ID, this.listenContextStarted);
            ((INotificationSupport)context).addNotificationListener(StopRequestedEvent.ID, this.listenContextStopRequested);
            ((INotificationSupport)context).addNotificationListener(StoppedEvent.ID, this.listenContextStopped);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.basicStart();
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.basicStop();
    }

    @Override
    public boolean stopRequested(Set visited) {
        return this.basicStopRequested(visited);
    }

    static {
        new CanonicalFromFactoryConverter();
    }
}

