/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.Expression;
import de.intarsys.tools.string.StringTools;
import java.util.Objects;

public class StringLiteral
extends Expression {
    private final String value;
    private final char quote;

    public StringLiteral(String value, char quote) {
        Objects.requireNonNull(value, "'value' must be nun null");
        this.value = value;
        this.quote = quote;
    }

    @Override
    public String getCode() {
        return StringTools.quote(this.value, this.quote);
    }

    public char getQuote() {
        return this.quote;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isQuoted() {
        return true;
    }

    @Override
    public boolean isString() {
        return true;
    }
}

