/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.expression.Expression;
import java.util.ArrayList;
import java.util.List;

public class Function
extends Expression {
    private final String name;
    private final List<Expression> args;

    public Function(String value, Expression ... args) {
        this.name = value;
        this.args = ListTools.with(args);
    }

    public Function(String value, List<Expression> args) {
        this.name = value;
        this.args = new ArrayList<Expression>(args);
    }

    @Override
    public String getCode() {
        boolean addSeparator = false;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("(");
        for (Expression arg : this.args) {
            if (addSeparator) {
                sb.append(",");
            }
            sb.append(arg.getCode());
            addSeparator = true;
        }
        sb.append(")");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFunction() {
        return true;
    }
}

