/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.Expression;
import de.intarsys.tools.expression.Function;
import de.intarsys.tools.expression.Parantheses;
import de.intarsys.tools.expression.StringLiteral;
import de.intarsys.tools.expression.Token;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class ExpressionParser {
    private final char delimiter;

    public ExpressionParser() {
        this.delimiter = (char)59;
    }

    public ExpressionParser(char delimiter) {
        this.delimiter = delimiter;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public Expression parse(Reader reader) throws IOException {
        Expression result = this.parseExpression(reader, false);
        reader.read();
        return result;
    }

    protected Expression parseExpression(Reader reader, boolean nested) throws IOException {
        int i;
        do {
            reader.mark(2);
            i = reader.read();
            if (i != -1 && i != this.delimiter && i != 41) continue;
            reader.reset();
            return null;
        } while (Character.isWhitespace(i));
        if (i == 44) {
            reader.reset();
            return new Token("");
        }
        if (i == 34 || i == 39) {
            return this.parseStringLiteral(reader, (char)i);
        }
        if (i == 40) {
            return this.parseParantheses(reader);
        }
        reader.reset();
        return this.parseTokenOrFunction(reader, nested);
    }

    protected Expression parseFunction(Reader reader, String name) throws IOException {
        ArrayList<Expression> args = new ArrayList<Expression>();
        Expression arg = this.parseExpression(reader, true);
        while (arg != null) {
            args.add(arg);
            arg = null;
            reader.mark(2);
            int i = reader.read();
            if (i == -1 || i == this.delimiter) {
                throw new IOException("unexpected end of expression");
            }
            if (i == 41) {
                reader.reset();
                continue;
            }
            if (Character.isWhitespace(i)) continue;
            if (i == 44) {
                arg = this.parseExpression(reader, true);
                continue;
            }
            throw new IOException("unexpected char '" + (char)i + "' in expression");
        }
        reader.read();
        return new Function(name, args);
    }

    protected Expression parseParantheses(Reader reader) throws IOException {
        Expression result;
        block2: {
            int i;
            result = this.parseExpression(reader, true);
            do {
                if ((i = reader.read()) == -1 || i == this.delimiter) {
                    throw new IOException("unexpected end of expression");
                }
                if (i == 41) break block2;
            } while (Character.isWhitespace(i) || i != 44);
            throw new IOException("unexpected char '" + (char)i + "' in expression");
        }
        return new Parantheses(result);
    }

    protected StringLiteral parseStringLiteral(Reader reader, char quote) throws IOException {
        StringBuilder sb = new StringBuilder();
        int i;
        while ((i = reader.read()) != -1) {
            if (i == 92) {
                String mapped;
                i = reader.read();
                if (i == -1 || (mapped = StringTools.ESCAPES.get(Character.valueOf((char)i))) == null) continue;
                sb.append(mapped);
                continue;
            }
            if (i == quote) {
                return new StringLiteral(sb.toString(), quote);
            }
            sb.append((char)i);
        }
        return new StringLiteral(sb.toString(), quote);
    }

    protected Expression parseTokenOrFunction(Reader reader, boolean nested) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            reader.mark(2);
            int i = reader.read();
            if (i == -1) {
                return new Token(sb.toString().trim());
            }
            if (i == 44 || i == 41 || i == this.delimiter && !nested) {
                reader.reset();
                return new Token(sb.toString().trim());
            }
            if (i == 40) {
                return this.parseFunction(reader, sb.toString().trim());
            }
            sb.append((char)i);
        }
    }
}

