/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.adapter.AdapterOutlet;
import de.intarsys.tools.expression.ArrayResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorSupport;
import de.intarsys.tools.expression.ListResolver;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.NamespaceNotFound;
import de.intarsys.tools.expression.ReflectiveResolver;
import de.intarsys.tools.expression.StaticArgsResolver;
import de.intarsys.tools.expression.VariableNamespaceResolver;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.valueholder.IValueHolder;
import de.intarsys.tools.variable.IVariableNamespace;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public abstract class ContainerResolver
implements IStringEvaluator {
    public static final char PATH_SEPARATOR = '.';
    private IStringEvaluator exceptionResolver;
    private final char separator;
    private boolean strict;
    private Object notFoundResult;

    protected ContainerResolver() {
        this('.');
    }

    protected ContainerResolver(char separator) {
        this(separator, true, null);
    }

    protected ContainerResolver(char separator, boolean strict, IStringEvaluator exceptionResolver) {
        this.separator = separator;
        this.strict = strict;
        this.exceptionResolver = exceptionResolver;
    }

    protected abstract Object basicEvaluate(String var1, IArgs var2) throws EvaluationException;

    protected Object basicEvaluateUnwrapped(String expression, IArgs args) throws EvaluationException {
        Object result = this.basicEvaluate(expression, args);
        if (result instanceof IValueHolder) {
            result = ((IValueHolder)result).get();
        }
        if (result instanceof Supplier) {
            result = ((Supplier)result).get();
        }
        return result;
    }

    protected IStringEvaluator createStringEvaluator(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IStringEvaluator) {
            return (IStringEvaluator)object;
        }
        if (object instanceof IStringEvaluatorSupport) {
            return ((IStringEvaluatorSupport)object).getStringEvaluator();
        }
        IStringEvaluator evaluator = object instanceof Map ? MapResolver.create((Map)object) : (object instanceof List ? new ListResolver((List)object) : (object instanceof IArgs ? new StaticArgsResolver((IArgs)object) : (object instanceof IVariableNamespace ? new VariableNamespaceResolver((IVariableNamespace)object) : (object instanceof Object[] ? new ArrayResolver((Object[])object) : AdapterOutlet.get().getAdapter(object, IStringEvaluator.class)))));
        if (evaluator == null) {
            evaluator = new ReflectiveResolver(object);
        }
        if (evaluator instanceof ContainerResolver) {
            ((ContainerResolver)evaluator).setStrict(this.isStrict());
        }
        return evaluator;
    }

    @Override
    public final Object evaluate(String expression, IArgs args) throws EvaluationException {
        Object result;
        int pos = expression.indexOf(this.getSeparator());
        if (pos == -1) {
            try {
                return this.basicEvaluateUnwrapped(expression, args);
            }
            catch (EvaluationException e) {
                if (this.exceptionResolver != null) {
                    return this.exceptionResolver.evaluate(expression, args);
                }
                throw e;
            }
        }
        String exprLead = expression.substring(0, pos);
        String exprTrail = expression.substring(pos + 1);
        try {
            result = this.basicEvaluateUnwrapped(exprLead, args);
        }
        catch (EvaluationException e) {
            if (this.exceptionResolver != null) {
                return this.exceptionResolver.evaluate(expression, args);
            }
            throw new NamespaceNotFound(e.getMessage(), e.getCause());
        }
        IStringEvaluator subResolver = this.createStringEvaluator(result);
        if (subResolver != null) {
            try {
                return subResolver.evaluate(exprTrail, args);
            }
            catch (NamespaceNotFound e) {
                throw new EvaluationException(e.getMessage(), e.getCause());
            }
        }
        return this.notFound(expression);
    }

    protected EvaluationException failed(String expression) throws EvaluationException {
        throw new EvaluationException("can't evaluate '" + expression + "'");
    }

    public IStringEvaluator getExceptionResolver() {
        return this.exceptionResolver;
    }

    public Object getNotFoundResult() {
        return this.notFoundResult;
    }

    public final char getSeparator() {
        return this.separator;
    }

    public boolean isStrict() {
        return this.strict;
    }

    protected Object notFound(String expression) throws EvaluationException {
        if (this.isStrict()) {
            throw this.failed(expression);
        }
        return this.getNotFoundResult();
    }

    public void setExceptionResolver(IStringEvaluator exceptionResolver) {
        this.exceptionResolver = exceptionResolver;
    }

    public void setNotFoundResult(Object notFoundResult) {
        this.notFoundResult = notFoundResult;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

