/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto;

import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.crypto.ICryptdec;
import de.intarsys.tools.crypto.PBAES128CryptdecFactory;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.StringEvaluatorTools;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.system.SystemTools;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CryptoTools {
    private static final Logger Log = LoggerFactory.getLogger(CryptoTools.class);

    public static Secret createSecret(Object value) {
        if (value instanceof String) {
            value = StringEvaluatorTools.evaluate(TemplateEvaluator.get(Mode.UNTRUSTED), value);
        }
        if (value == null) {
            return Secret.EMPTY;
        }
        if (value instanceof char[]) {
            return Secret.hideTrimmed((char[])value);
        }
        if (value instanceof byte[]) {
            return Secret.hide((byte[])value);
        }
        if (value instanceof String) {
            return Secret.hideTrimmed(((String)value).toCharArray());
        }
        if (value instanceof Secret) {
            return (Secret)value;
        }
        throw new IllegalArgumentException("cannot convert " + value + " to Secret");
    }

    public static SecureRandom createSecureRandom() {
        SecureRandom secureRandom;
        String algorithm = SystemTools.isLinux() ? "NativePRNGNonBlocking" : "SHA1PRNG";
        try {
            secureRandom = SecureRandom.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            secureRandom = new SecureRandom();
        }
        return secureRandom;
    }

    public static ICryptdec createSessionCryptdec() {
        Secret passPhrase = null;
        byte[] salt = null;
        byte[] iv = null;
        passPhrase = Secret.create(16);
        salt = ByteArrayTools.createRandomBytes(8);
        iv = ByteArrayTools.createRandomBytes(16);
        try {
            ICryptdec iCryptdec = new PBAES128CryptdecFactory("session", iv, passPhrase, salt, 19).createCryptdec();
            return iCryptdec;
        }
        catch (Exception e) {
            throw new IllegalStateException("cryptdec initialization error", e);
        }
        finally {
            Arrays.fill(salt, (byte)0);
            Arrays.fill(iv, (byte)0);
        }
    }

    public static byte[] getBytes(Secret secret) throws GeneralSecurityException {
        return secret == null ? null : secret.getBytes();
    }

    public static byte[] getBytes(Secret secret, byte[] defaultValue) {
        try {
            return secret == null ? null : secret.getBytes();
        }
        catch (GeneralSecurityException e) {
            Log.warn("failed to decrypt {}, return default value", (Object)secret);
            return defaultValue;
        }
    }

    public static byte[] getBytesNotNull(Secret secret) throws GeneralSecurityException {
        return secret == null || secret.isEmpty() ? new byte[]{} : secret.getBytes();
    }

    public static byte[] getBytesNotNull(Secret secret, byte[] defaultValue) {
        try {
            return secret == null || secret.isEmpty() ? new byte[]{} : secret.getBytes();
        }
        catch (GeneralSecurityException e) {
            Log.warn("failed to decrypt {}, return default value", (Object)secret);
            return defaultValue;
        }
    }

    public static char[] getChars(Secret secret) throws GeneralSecurityException {
        return secret == null ? null : secret.getChars();
    }

    public static char[] getChars(Secret secret, char[] defaultValue) {
        try {
            return secret == null ? null : secret.getChars();
        }
        catch (GeneralSecurityException e) {
            Log.warn("failed to decrypt {}, return default value", (Object)secret);
            return defaultValue;
        }
    }

    public static char[] getCharsNotNull(Secret secret) throws GeneralSecurityException {
        return secret == null || secret.isEmpty() ? new char[]{} : secret.getChars();
    }

    public static char[] getCharsNotNull(Secret secret, char[] defaultValue) {
        try {
            return secret == null || secret.isEmpty() ? new char[]{} : secret.getChars();
        }
        catch (GeneralSecurityException e) {
            Log.warn("failed to decrypt {}, return default value", (Object)secret);
            return defaultValue;
        }
    }

    public static String getString(Secret secret) throws GeneralSecurityException {
        return secret == null ? null : secret.getString();
    }

    public static String getString(Secret secret, String defaultValue) {
        try {
            return secret == null ? null : secret.getString();
        }
        catch (GeneralSecurityException e) {
            Log.warn("failed to decrypt {}, return default value", (Object)secret);
            return defaultValue;
        }
    }

    public static String getStringNotNull(Secret secret) throws GeneralSecurityException {
        return secret == null || secret.isEmpty() ? "" : secret.getString();
    }

    public static String getStringNotNull(Secret secret, String defaultValue) {
        try {
            return secret == null || secret.isEmpty() ? "" : secret.getString();
        }
        catch (GeneralSecurityException e) {
            Log.warn("failed to decrypt {}, return default value", (Object)secret);
            return defaultValue;
        }
    }

    public static boolean isEmpty(Secret secret) {
        return secret == null || secret.isEmpty();
    }

    private CryptoTools() {
    }
}

