/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.converter;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.IConverter;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class DurationFromStringConverter
implements IConverter<String, Duration> {
    private static final Pattern SIMPLE_PATTERN = Pattern.compile("(?<amount>[+-]?\\d+)\\s*(?<suffix>[a-z]+)", 2);

    @Override
    public Duration convert(String source) throws ConversionException {
        Matcher matcher = SIMPLE_PATTERN.matcher(source);
        if (matcher.matches()) {
            try {
                long amount = Long.parseLong(matcher.group("amount"));
                Unit unit = Unit.fromSuffix(matcher.group("suffix"));
                return unit.ofAmount(amount);
            }
            catch (NumberFormatException | NoSuchElementException exception) {
                throw new ConversionException("Invalid duration", exception);
            }
        }
        try {
            return Duration.parse(source);
        }
        catch (DateTimeParseException exception) {
            throw new ConversionException("Invalid duration", exception);
        }
    }

    @Override
    public Class<?> getSourceType() {
        return String.class;
    }

    @Override
    public Class<?> getTargetType() {
        return Duration.class;
    }

    static enum Unit {
        NANOS(ChronoUnit.NANOS, "ns"),
        MILLIS(ChronoUnit.MILLIS, "ms"),
        SECONDS(ChronoUnit.SECONDS, "s"),
        MINUTES(ChronoUnit.MINUTES, "m"),
        HOURS(ChronoUnit.HOURS, "h"),
        DAYS(ChronoUnit.DAYS, "d");

        private final ChronoUnit chronoUnit;
        private final String suffix;

        static Unit fromSuffix(String suffix) {
            return Stream.of(Unit.values()).filter(unit -> unit.suffix.equalsIgnoreCase(suffix)).findFirst().orElseThrow(() -> new NoSuchElementException("Unknown unit: " + suffix));
        }

        private Unit(ChronoUnit chronoUnit, String suffix) {
            this.chronoUnit = chronoUnit;
            this.suffix = suffix;
        }

        Duration ofAmount(long amount) {
            return Duration.of(amount, this.chronoUnit);
        }
    }
}

