/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.concurrent;

import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.ITaskCallbackSupport;
import de.intarsys.tools.concurrent.ITaskListener;
import de.intarsys.tools.concurrent.TaskFailed;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class TaskCallbackDispatcher<R>
implements ITaskCallbackSupport<R>,
ITaskListener<R> {
    private final List<ITaskCallback<R>> callbacks = new CopyOnWriteArrayList<ITaskCallback<R>>();

    @Override
    public void addTaskCallback(ITaskCallback<R> callback) {
        if (callback == null) {
            throw new NullPointerException("listener may not be null");
        }
        this.callbacks.add(callback);
    }

    public void attach(ITaskCallbackSupport<R> support) {
        for (ITaskCallback<R> listener : this.callbacks) {
            support.addTaskCallback(listener);
        }
    }

    public void clear() {
        this.callbacks.clear();
    }

    public void detach(ITaskCallbackSupport<R> support) {
        for (ITaskCallback<R> listener : this.callbacks) {
            support.removeTaskCallback(listener);
        }
    }

    @Override
    public void failed(TaskFailed exception) {
        ListIterator<ITaskCallback<R>> it = this.callbacks.listIterator();
        while (it.hasNext()) {
            ITaskCallback<R> callback = it.next();
            callback.failed(exception);
        }
    }

    @Override
    public void finished(R result) {
        ListIterator<ITaskCallback<R>> it = this.callbacks.listIterator();
        while (it.hasNext()) {
            ITaskCallback<R> callback = it.next();
            callback.finished(result);
        }
    }

    public boolean isEmpty() {
        return this.callbacks.isEmpty();
    }

    @Override
    public void removeTaskCallback(ITaskCallback<R> listener) {
        this.callbacks.remove(listener);
    }

    @Override
    public void started() {
        for (ITaskCallback<R> listener : this.callbacks) {
            if (!(listener instanceof ITaskListener)) continue;
            ((ITaskListener)listener).started();
        }
    }
}

