/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.component;

import de.intarsys.tools.component.IMetaInfoSupport;
import de.intarsys.tools.component.VersionTools;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;

public class MetaInfoResolver
implements IStringEvaluator {
    private final IMetaInfoSupport metaInfo;

    public MetaInfoResolver(IMetaInfoSupport metaInfo) {
        this.metaInfo = metaInfo;
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        if ("name".equals(expression)) {
            return this.metaInfo.getMetaInfo("name");
        }
        if ("version".equals(expression)) {
            return this.metaInfo.getMetaInfo("version");
        }
        if ("major".equals(expression)) {
            String version = this.metaInfo.getMetaInfo("version");
            return VersionTools.getMajor(version);
        }
        if ("micro".equals(expression)) {
            String version = this.metaInfo.getMetaInfo("version");
            return VersionTools.getMicro(version);
        }
        if ("minor".equals(expression)) {
            String version = this.metaInfo.getMetaInfo("version");
            return VersionTools.getMinor(version);
        }
        String value = this.metaInfo.getMetaInfo(expression);
        if (value == null) {
            throw new EvaluationException("can't evaluate '" + expression + "'");
        }
        return value;
    }
}

