/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.component;

import de.intarsys.tools.component.ExpirationPredicate;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;

public class ExpireAnd
extends ExpirationPredicate {
    private final ExpirationPredicate op1;
    private final ExpirationPredicate op2;

    public ExpireAnd(ExpirationPredicate op1, ExpirationPredicate op2) {
        this.op1 = op1;
        this.op2 = op2;
    }

    @Override
    public ExpirationPredicate copy() {
        return new ExpireAnd(this.op1.copy(), this.op2.copy());
    }

    public ExpirationPredicate getOp1() {
        return this.op1;
    }

    public ExpirationPredicate getOp2() {
        return this.op2;
    }

    @Override
    public String getType() {
        return "and";
    }

    @Override
    public long getValue() {
        return 0L;
    }

    @Override
    public boolean isExpired() {
        if (!this.op1.isExpired()) {
            return false;
        }
        return this.op2.isExpired();
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("type", this.getType());
        IElement child = element.newElementMapped("op1");
        this.getOp1().serialize(child);
        child = element.newElementMapped("op2");
        this.getOp2().serialize(child);
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append("and(");
        sb.append(this.op1);
        sb.append(", ");
        sb.append(this.op2);
        sb.append(")");
    }

    @Override
    public void touch() {
        this.op1.touch();
        this.op2.touch();
    }
}

