/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.collection;

import de.intarsys.tools.collection.CommonBuilder;
import de.intarsys.tools.collection.MapTools;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IBaseFunctor;
import de.intarsys.tools.lang.LangTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public class ListTools {
    public static <T> List<T> addAll(List<T> list, Enumeration<T> e) {
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list;
    }

    public static <T> List<T> addAll(List<T> list, Iterable<T> iterable) {
        Iterator<T> it = iterable.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public static <T> List<T> addAll(List<T> list, Iterator<T> it) {
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public static <T> List<T> allocate(List<T> list, int count) {
        for (int i = count; i > 0; --i) {
            list.add(null);
        }
        return list;
    }

    public static List applyDeep(List list, Function<IArgs.IBinding, Object> function) {
        int i = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            LangTools.applyDeep(it.next(), function, new ListBinding(list, i++));
        }
        return list;
    }

    public static <E> Builder<E> builder() {
        return ListTools.builder(new ArrayList());
    }

    public static <E> Builder<E> builder(List<E> list) {
        return new Builder<E>(null, list);
    }

    public static <A, B> List<B> collect(Iterator<A> it, IBaseFunctor<B> converter) {
        ArrayList<B> result = new ArrayList<B>(5);
        while (it.hasNext()) {
            try {
                result.add(converter.perform(it.next()));
            }
            catch (FunctorException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return result;
    }

    public static <A, B> List<B> collect(List<A> list, IBaseFunctor<B> converter) {
        ArrayList<B> result = new ArrayList<B>(list.size());
        for (A a : list) {
            try {
                result.add(converter.perform(a));
            }
            catch (FunctorException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return result;
    }

    public static List copyDeep(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            result.add(LangTools.copyDeep(it.next()));
        }
        return result;
    }

    public static <A> A detect(List<A> list, IBaseFunctor<Boolean> selector) {
        for (A a : list) {
            try {
                if (!Boolean.TRUE.equals(selector.perform(a))) continue;
                return a;
            }
            catch (FunctorException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public static <T> T first(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static <T> T last(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <A> List<A> reject(List<A> list, IBaseFunctor<Boolean> selector) {
        ArrayList<A> result = new ArrayList<A>(list.size());
        for (A a : list) {
            try {
                if (Boolean.TRUE.equals(selector.perform(a))) continue;
                result.add(a);
            }
            catch (FunctorException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return result;
    }

    public static <A> List<A> select(List<A> list, IBaseFunctor<Boolean> selector) {
        ArrayList<A> result = new ArrayList<A>(list.size());
        for (A a : list) {
            try {
                if (!Boolean.TRUE.equals(selector.perform(a))) continue;
                result.add(a);
            }
            catch (FunctorException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return result;
    }

    public static <T> List<T> toList(Enumeration<T> e) {
        ArrayList<T> result = new ArrayList<T>(5);
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        return result;
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        ArrayList<T> result = new ArrayList<T>(5);
        Iterator<T> it = iterable.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static <T> List<T> toList(Iterator<T> it) {
        ArrayList<T> result = new ArrayList<T>(5);
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static <T> List<T> with(T ... objects) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, objects);
        return list;
    }

    private ListTools() {
    }

    public static class ListBinding
    implements IArgs.IBinding {
        private final List list;
        private final int index;

        public ListBinding(List list, int index) {
            this.list = list;
            this.index = index;
        }

        @Override
        public String getName() {
            return "" + this.index;
        }

        @Override
        public Object getValue() {
            return this.list.get(this.index);
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValue(Object value) {
            this.list.set(this.index, value);
        }
    }

    public static class Builder<E>
    extends CommonBuilder {
        private List<E> list;

        protected Builder(CommonBuilder parent, List<E> list) {
            super(parent);
            this.list = list;
        }

        public Builder<E> add(E value) {
            this.list.add(value);
            return this;
        }

        @Override
        public List<E> build() {
            return this.list;
        }

        public Builder startList() {
            return new Builder(this, new ArrayList()){

                @Override
                public CommonBuilder end() {
                    this.add(this.build());
                    return super.end();
                }
            };
        }

        public MapTools.Builder startMap() {
            return new MapTools.Builder(this, new HashMap()){

                @Override
                public CommonBuilder end() {
                    this.add(this.build());
                    return super.end();
                }
            };
        }
    }
}

