/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.codeexit;

import de.intarsys.tools.codeexit.CodeExit;
import de.intarsys.tools.codeexit.CommonCodeExitHandler;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorTools;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.infoset.IElement;

public class FunctorCodeExitHandler
extends CommonCodeExitHandler {
    protected Object compile(CodeExit codeExit) throws Exception {
        this.checkCodeExitSource(codeExit);
        Object result = null;
        IFactory<?> factory = FactoryTools.lookupFactoryFuzzy(codeExit.getSource(), codeExit.getClassLoader());
        InstanceSpec<Object> spec = InstanceSpec.createFromFactory(Object.class, factory, Args.create());
        IElement handlerElement = codeExit.getHandlerElement();
        if (handlerElement != null) {
            spec.getArgs().put("configuration", (Object)handlerElement);
        }
        spec.getArgs().put("classLoader", (Object)codeExit.getClassLoader());
        spec.getArgs().put("context", codeExit.getOwner());
        result = spec.createInstance();
        if (result == null) {
            throw new IllegalArgumentException("can not create IFunctor from " + codeExit.getSource());
        }
        return result;
    }

    public Object perform(CodeExit codeExit, IFunctorCall call) throws FunctorException {
        try {
            Object compiled = codeExit.getCompiledSource();
            if (compiled == null) {
                compiled = this.compile(codeExit);
                codeExit.setCompiledSource(compiled);
            }
            return FunctorTools.perform(compiled, call);
        }
        catch (Throwable e) {
            throw ExceptionTools.unwrapTyped(e, FunctorException.class);
        }
    }
}

