/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.blocks;

import de.intarsys.tools.blocks.IBlock;
import de.intarsys.tools.blocks.IScope;
import java.util.function.Consumer;

public class BlockConsumer
implements IBlock {
    private final Consumer<IScope> doTry;
    private final Consumer<IScope> doFinally;

    public BlockConsumer(Consumer<IScope> blockTry, Consumer<IScope> blockFinally) {
        this.doTry = blockTry;
        this.doFinally = blockFinally;
    }

    @Override
    public void runFinally(IScope scope) {
        if (this.doFinally != null) {
            scope.pop();
            this.doFinally.accept(scope);
        }
    }

    @Override
    public Object runTry(IScope scope) {
        if (this.doFinally != null) {
            scope.push(this);
        }
        if (this.doTry != null) {
            this.doTry.accept(scope);
        }
        return null;
    }
}

