/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.bean;

import de.intarsys.tools.bean.BeanContainer;
import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.IFunctor;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleDispatcher {
    private static final Logger Log = LoggerFactory.getLogger(LifecycleDispatcher.class);
    private final String role;

    public LifecycleDispatcher(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public void start() {
        for (Object object : BeanContainer.get().lookupBeans(this.getRole(), Object.class)) {
            try {
                if (object instanceof IStartStop) {
                    ((IStartStop)object).start();
                    continue;
                }
                if (object instanceof IFunctor) {
                    ((IFunctor)object).perform(FunctorCall.create(null, new Object[0]));
                    continue;
                }
                if (!(object instanceof Runnable)) continue;
                ((Runnable)object).run();
            }
            catch (Exception e) {
                Log.warn("{}.start has encountered exception {} ", new Object[]{this.getRole(), ExceptionTools.getMessage(e), e});
            }
        }
    }

    public void stop() {
        for (Object object : BeanContainer.get().lookupBeans(this.getRole(), Object.class)) {
            try {
                if (!(object instanceof IStartStop)) continue;
                ((IStartStop)object).stop();
            }
            catch (Exception e) {
                Log.warn("{}.stop has encountered exception {} ", new Object[]{this.getRole(), ExceptionTools.getMessage(e), e});
            }
        }
    }

    public boolean stopRequested(Set visited) {
        for (Object object : BeanContainer.get().lookupBeans(this.getRole(), Object.class)) {
            try {
                if (!(object instanceof IStartStop) || ((IStartStop)object).stopRequested(visited)) continue;
                return false;
            }
            catch (Exception e) {
                Log.warn("{}.stopRequested has encountered exception {} ", new Object[]{this.getRole(), ExceptionTools.getMessage(e), e});
            }
        }
        return true;
    }
}

