/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.adapter;

import de.intarsys.tools.adapter.AdapterOutlet;
import de.intarsys.tools.adapter.IAdapterFactory;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.exception.TunnelingException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericAdapterFactory
implements IAdapterFactory<Object>,
IElementConfigurable,
IContextSupport {
    private static final Logger Log = LoggerFactory.getLogger(GenericAdapterFactory.class);
    private IElement element;
    private Object context;
    private Class<Object> baseType;
    private Class<Object> targetType;
    private Object adapter;

    public GenericAdapterFactory() {
    }

    public GenericAdapterFactory(Class baseType, Class targetType, Object adapter) {
        this.baseType = baseType;
        this.targetType = targetType;
        this.adapter = adapter;
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        this.element = element;
    }

    @Override
    public <T> T getAdapter(Object object, Class<T> clazz) {
        try {
            if (this.getTargetType().equals(clazz)) {
                if (this.adapter == null) {
                    this.adapter = ElementTools.createObject(this.getElement(), "adapterclass", clazz, this.getContext(), Args.create());
                }
                return (T)this.adapter;
            }
        }
        catch (ObjectCreationException e) {
            Log.error("error creating adapter", (Throwable)e);
        }
        return null;
    }

    @Override
    public Class<Object> getBaseType() {
        if (this.baseType == null) {
            try {
                this.baseType = ElementTools.createClass(this.getElement(), "baseclass", Object.class, this.getContext());
                if (this.baseType == null) {
                    throw new RuntimeException("baseclass must be defined");
                }
            }
            catch (ObjectCreationException e) {
                String msg = "generic adapter factory error loading base type";
                Log.warn("{} ({})", (Object)msg, (Object)ExceptionTools.getMessage(e));
                throw new TunnelingException(msg, e);
            }
        }
        return this.baseType;
    }

    public Object getContext() {
        return this.context;
    }

    public IElement getElement() {
        return this.element;
    }

    public Class<?> getTargetType() {
        if (this.targetType == null) {
            try {
                this.targetType = ElementTools.createClass(this.getElement(), "targetclass", Object.class, this.getContext());
                if (this.targetType == null) {
                    throw new RuntimeException("targetclass must be defined");
                }
            }
            catch (ObjectCreationException e) {
                String msg = "generic adapter factory error loading target type";
                Log.warn("{} ({})", (Object)msg, (Object)ExceptionTools.getMessage(e));
                throw new TunnelingException(msg, e);
            }
        }
        return this.targetType;
    }

    @PostConstruct
    public void register() {
        AdapterOutlet.get().registerAdapterFactory(this);
    }

    @Override
    public void setContext(Object context) {
        this.context = context;
    }
}

