/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.activity.web;

import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.IActivityView;
import de.intarsys.tools.activity.RequestPassword;
import de.intarsys.tools.activity.web.WebActivityHandler;
import de.intarsys.tools.activity.web.WebActivityView;
import de.intarsys.tools.concurrent.IPromise;
import de.intarsys.tools.conversation.ConversationRegistry;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jaxrs.RequestContext;
import de.intarsys.tools.string.StringTools;
import jakarta.ws.rs.core.UriBuilder;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestPasswordHandler
extends WebActivityHandler {
    private static final String PARAM_STATE = "state";
    private static final Logger Log = LoggerFactory.getLogger(RequestPasswordHandler.class);

    protected void acknowledge(WebActivityView view, Object value) {
        try {
            String tmpValue = (String)ConverterRegistry.get().convert(value, String.class);
            if (StringTools.isEmpty((String)tmpValue)) {
                view.getConversation().cancel(true);
            } else {
                Secret secret = Secret.hide((char[])tmpValue.toCharArray());
                view.getConversation().complete((Object)secret);
            }
        }
        catch (Exception e) {
            view.getConversation().completeExceptionally((Throwable)e);
        }
    }

    protected Object activityFail(IPromise promise, Throwable t) {
        promise.fail(t);
        return null;
    }

    protected Object activityFinish(IPromise promise, Object value) {
        promise.finish(value);
        return null;
    }

    @Override
    protected <R> IActivityView basicActivityEnter(IActivity<R> activity) {
        IConversation<R> conversation = this.createConversation((IArgs)Args.create());
        conversation.thenAccept(value -> this.activityFinish((IPromise)activity, value)).exceptionally(ex -> {
            this.activityFail((IPromise)activity, (Throwable)ex);
            return null;
        });
        WebActivityView view = new WebActivityView(activity, conversation);
        try {
            RequestPassword requester = (RequestPassword)activity;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("label", requester.getTitle().getString());
            parameters.put("description", requester.getMessage().getString());
            conversation.setAttribute((Object)"parameters", parameters);
            UriBuilder uriBuilder = RequestContext.get().getUriBuilderContext();
            uriBuilder.path(this.getUiPath());
            uriBuilder.path(this.getUiPage());
            uriBuilder.queryParam(PARAM_STATE, new Object[]{conversation.getHandle()});
            String redirectUri = uriBuilder.toString();
            Log.info("{} redirect to {}", (Object)conversation.getHandle(), (Object)redirectUri);
            HttpRedirectStage replyStage = new HttpRedirectStage(redirectUri, false, true);
            conversation.setReplyStage((IReplyStage)replyStage);
            ConversationRegistry.publishForLifetime(conversation);
            replyStage.onAck(value -> this.acknowledge(view, value));
        }
        catch (Exception e) {
            conversation.completeExceptionally((Throwable)e);
        }
        return view;
    }

    protected <R> IConversation<R> createConversation(IArgs args) {
        return new Conversation("request-" + this.toString());
    }

    protected String getUiPage() {
        return "pin.html";
    }

    protected String getUiPath() {
        return "html";
    }
}

