/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.jca.wrappedsigner;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.jca.wrappedsigner.WrappedSignerKeystoreSpi;
import de.intarsys.security.jca.wrappedsigner.WrappedSignerSignatureSpi;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigester;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

public class WrappedSignerProvider
extends Provider {
    private static final String KEYSTORE = "KeyStore";
    private static final String SIGNATURE = "Signature";
    private ISigner signer;

    public WrappedSignerProvider(ISigner signer) {
        this(signer, signer.getClass().getName());
    }

    public WrappedSignerProvider(ISigner signer, String name) {
        super(name, 1.0, "");
        this.signer = signer;
    }

    @Override
    public synchronized Provider.Service getService(String type, String algorithm) {
        if (KEYSTORE.equals(type)) {
            return new Provider.Service(this, KEYSTORE, algorithm, "", null, null){

                @Override
                public Object newInstance(Object constructorParameter) {
                    return new WrappedSignerKeystoreSpi(WrappedSignerProvider.this.signer);
                }
            };
        }
        if (SIGNATURE.equals(type)) {
            String hashAlgorithmName = SignatureAlgorithm.deriveHashAlgorithmName((String)algorithm);
            final DigestAlgorithm hashAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)hashAlgorithmName);
            if (hashAlgorithm == null) {
                return null;
            }
            return new Provider.Service(this, SIGNATURE, algorithm, "", null, null){

                @Override
                public Object newInstance(Object constructorParameter) {
                    IDigester digester;
                    try {
                        digester = DigestTools.createDigester((String)hashAlgorithm.getCanonicalName());
                    }
                    catch (NoSuchAlgorithmException e) {
                        return null;
                    }
                    return new WrappedSignerSignatureSpi(WrappedSignerProvider.this.signer, digester);
                }
            };
        }
        return super.getService(type, algorithm);
    }
}

