/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.jca.device;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.IAuthenticatedApplication;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.jca.device.DeviceSignerPrivateKey;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.ToBeSignedData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.driver.ConversationDriver;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.concurrent.ExecutionException;

public class DeviceSignerSignatureSpi
extends SignatureSpi {
    public static final String ARG_RSASIGNATUREENCODING = "rsaSignatureEncoding";
    public static final String RSAENCODING_RSA = "RSA";
    public static final String RSAENCODING_RSASSAPSS = "RSASSA-PSS";
    private IArgs signerArgs = Args.create();
    private ISigner signer;
    private IDigester digester;

    public static DeviceSignerSignatureSpi create(String algorithm) {
        IDigester digester;
        String hashAlgorithmName = SignatureAlgorithm.deriveHashAlgorithmName((String)algorithm);
        DigestAlgorithm hashAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)hashAlgorithmName);
        if (hashAlgorithm == null) {
            return new DeviceSignerSignatureSpi();
        }
        try {
            digester = DigestTools.createDigester((String)hashAlgorithm.getCanonicalName());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        return new DeviceSignerSignatureSpi(digester);
    }

    public DeviceSignerSignatureSpi() {
    }

    public DeviceSignerSignatureSpi(IDigester digester) {
        this.digester = digester;
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) {
        if (!(privateKey instanceof DeviceSignerPrivateKey)) {
            throw new IllegalArgumentException();
        }
        ISigner signer = ((DeviceSignerPrivateKey)privateKey).createSigner(this.signerArgs);
        if (signer == null) {
            throw new IllegalStateException("signer cannot be created");
        }
        if (!signer.isBasic()) {
            throw new IllegalStateException("signer must be on basic level");
        }
        try {
            ((IAuthenticatedApplication)((Object)signer)).authenticate().get();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot authenticate with signer app: " + e.getMessage(), e);
        }
        this.signer = signer;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) {
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params instanceof PSSParameterSpec) {
            PSSParameterSpec pssParams = (PSSParameterSpec)params;
            DigestAlgorithm hashAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)pssParams.getDigestAlgorithm());
            if (hashAlgorithm == null) {
                throw new InvalidAlgorithmParameterException("hash algorithm: " + hashAlgorithm);
            }
            try {
                this.digester = DigestTools.createDigester((String)hashAlgorithm.getCanonicalName());
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidAlgorithmParameterException("hash algorithm: " + hashAlgorithm);
            }
            ArgTools.putPath((IArgs)this.signerArgs, (String)ARG_RSASIGNATUREENCODING, (Object)RSAENCODING_RSASSAPSS);
        }
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            IDigest digest = this.digester.digestFinal();
            ToBeSignedData data = ToBeSignedData.create((IDigest)digest);
            IConversation<ISignatureData> conversation = this.signer.sign((IToBeSignedData)data);
            return ((ISignatureData)ConversationDriver.get().get(conversation)).getEncodedSignature();
        }
        catch (ExecutionException e) {
            SecurityApplicationException cause = (SecurityApplicationException)ExceptionTools.unwrapTyped((Throwable)e, SecurityApplicationException.class);
            throw new SignatureException(e.getLocalizedMessage(), cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SignatureException(e.getLocalizedMessage(), e);
        }
        catch (Exception e) {
            throw new SignatureException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    protected void engineUpdate(byte b) {
        try {
            this.digester.digestUpdate((InputStream)new ByteArrayInputStream(new byte[]{b}));
        }
        catch (IOException e) {
            throw new IllegalStateException("byte array input stream failed");
        }
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) {
        try {
            this.digester.digestUpdate((InputStream)new ByteArrayInputStream(b, off, len));
        }
        catch (IOException e) {
            throw new IllegalStateException("byte array input stream failed");
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) {
        return false;
    }
}

