/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.jca.conversationsigner;

import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.tools.collection.SingleObjectEnumeration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;

public class ConversationSignerKeystoreSpi
extends KeyStoreSpi {
    private static final PrivateKey privateKey = new PrivateKey(){

        @Override
        public String getAlgorithm() {
            return "RSA";
        }

        @Override
        public byte[] getEncoded() {
            return null;
        }

        @Override
        public String getFormat() {
            return null;
        }
    };
    private ISigner signer;
    private String alias;

    public ConversationSignerKeystoreSpi(ISigner signer) {
        this.signer = signer;
        if (!signer.isBasic()) {
            throw new IllegalArgumentException("signer must be on basic level");
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        return new SingleObjectEnumeration((Object)this.getAlias());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.getAlias().equals(alias);
    }

    @Override
    public void engineDeleteEntry(String alias) {
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (this.getAlias().equals(alias)) {
            try {
                return this.getCertificate().toJavaCertificate();
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (cert instanceof X509Certificate) {
            String serial = ((X509Certificate)cert).getSerialNumber().toString();
            if (this.getAlias().equals(serial)) {
                return serial;
            }
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        if (this.getAlias().equals(alias)) {
            IX509PublicKeyCertificate[] certs = this.signer.getCertificatePath();
            Certificate[] result = new Certificate[certs.length];
            try {
                for (int i = 0; i < certs.length; ++i) {
                    result[i] = certs[i].toJavaCertificate();
                }
                return result;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return null;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) {
        if (this.getAlias().equals(alias)) {
            return privateKey;
        }
        return null;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return this.getAlias().equals(alias);
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) {
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) {
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) {
    }

    @Override
    public int engineSize() {
        return 1;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) {
    }

    private String getAlias() {
        if (this.alias == null) {
            this.alias = this.getCertificate().getSerialNumber().toString();
        }
        return this.alias;
    }

    private IX509PublicKeyCertificate getCertificate() {
        return this.signer.getCertificatePath()[0];
    }

    public static interface PrivateKey
    extends java.security.PrivateKey {
    }
}

