/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.health;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.health.ConcurrentHealthMonitor;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import org.glassfish.jersey.client.ClientConfig;

public class ActuatorHealthMonitor
extends ConcurrentHealthMonitor<CommonDevice> {
    private String baseUrl;
    private String path = "manage/health";
    private Client client;
    private String jsonPtr;

    @Override
    protected void basicStartEnabled() {
        super.basicStartEnabled();
        this.client = this.createClient();
    }

    @Override
    protected void basicStop() {
        super.basicStop();
        if (this.client != null) {
            this.client.close();
        }
    }

    protected Client createClient() {
        JacksonJsonProvider jacksonProvider = new JacksonJsonProvider();
        ClientConfig config = new ClientConfig().register((Object)jacksonProvider).property("jersey.config.client.followRedirects", (Object)false);
        ClientBuilder builder = ClientBuilder.newBuilder().withConfig((Configuration)config);
        return builder.build();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    protected Client getClient() {
        return this.client;
    }

    private URI getEndpoint() {
        URI pathUri = URI.create(this.getPath());
        if (pathUri.isAbsolute()) {
            return pathUri;
        }
        if (StringTools.isEmpty((String)this.getBaseUrl())) {
            throw ExceptionTools.argumentRequired((String)"baseUrl");
        }
        UriBuilder builder = UriBuilder.fromPath((String)this.getBaseUrl());
        return builder.path(this.getPath()).build(new Object[0]);
    }

    public String getJsonPtr() {
        return this.jsonPtr;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    protected void monitor() {
        try {
            WebTarget target = this.getClient().target(this.getEndpoint());
            Invocation.Builder builder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            Response response = builder.get();
            Response.StatusType statusInfo = response.getStatusInfo();
            if (!statusInfo.getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                if (StringTools.isEmpty((String)this.getJsonPtr())) {
                    throw new IOException("HTTP error " + statusInfo.getStatusCode() + " (" + statusInfo.getReasonPhrase() + ")");
                }
                JsonNode content = (JsonNode)response.readEntity(JsonNode.class);
                JsonNode status = content.at(this.getJsonPtr() + "/status");
                JsonNode reason = content.at(this.getJsonPtr() + "/details/stateReason");
                if (status == null || status.isMissingNode() || !status.asText().equalsIgnoreCase("UP")) {
                    throw new IOException("HTTP error " + statusInfo.getStatusCode() + " (" + reason.asText() + ")");
                }
            }
            this.success();
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    @Override
    public void setArgs(IArgs args) {
        super.setArgs(args);
        this.setBaseUrl(ArgTools.getString((IArgs)args, (String)"baseUrl", null));
        this.setBaseUrl(ArgTools.getString((IArgs)args, (String)"path", null));
        this.setJsonPtr(ArgTools.getString((IArgs)args, (String)"jsonPtr", null));
    }

    public void setBaseUrl(String endpoint) {
        this.baseUrl = endpoint;
    }

    public void setJsonPtr(String jsonPtr) {
        this.jsonPtr = jsonPtr;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

