/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;

public abstract class CommonDeviceFactoryBean<T extends CommonDevice>
extends AbstractFactoryBean<T>
implements ApplicationListener<ApplicationContextEvent> {
    @Autowired
    private ApplicationContext appContext;
    private String id;
    private CommonDeviceProvider deviceProvider;

    public CommonDeviceFactoryBean() {
        this.setSingleton(true);
    }

    protected abstract CommonDeviceProvider createDeviceProvider();

    public CommonDeviceProvider getDeviceProvider() {
        return this.deviceProvider;
    }

    protected CommonDeviceProvider getDeviceProviderOrDefault() {
        CommonDeviceProvider provider = this.getDeviceProvider();
        if (provider == null) {
            this.deviceProvider = provider = this.createDeviceProvider();
        }
        return provider;
    }

    public String getId() {
        return this.id;
    }

    public String getLogLabel() {
        return this.getDeviceProviderOrDefault().getLabel() + " creating '" + this.getId() + "'";
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        CommonDevice device;
        if (event.getApplicationContext() != this.appContext) {
            return;
        }
        try {
            device = (CommonDevice)this.getObject();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (device == null) {
            return;
        }
        if (event instanceof ContextRefreshedEvent) {
            device.onContextRefreshed();
        }
        if (event instanceof ContextClosedEvent) {
            device.onContextClosed();
        }
    }

    public void setDeviceProvider(CommonDeviceProvider deviceProvider) {
        this.deviceProvider = deviceProvider;
    }

    public void setId(String id) {
        this.id = id;
    }
}

