/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import de.intarsys.security.device.ICredential;
import de.intarsys.security.device.IDevice;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.notice.INotice;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class CommonCredential
implements ICredential,
INotificationSupport {
    private final AttributeMap attributes = new AttributeMap();
    private final EventDispatcher eventDispatcher = new EventDispatcher((Object)this);
    private final String id;
    private final IDevice device;
    protected final Object lock = new Object();
    private final List<INotice> notices = new CopyOnWriteArrayList<INotice>();

    public CommonCredential(IDevice device, String id) {
        this.device = device;
        assert (id != null);
        this.id = id;
    }

    public void addNotice(INotice notice) {
        this.notices.add(notice);
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"notices", null, (Object)notice));
    }

    public <T extends Event> void addNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.eventDispatcher.addNotificationListener(type, listener);
    }

    public void clearNotices() {
        this.notices.clear();
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"notices", null, null));
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    protected AttributeMap getAttributes() {
        return this.attributes;
    }

    @Override
    public IDevice getDevice() {
        return this.device;
    }

    protected EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public abstract String getLabel();

    @Override
    public abstract String getName();

    public List<INotice> getNotices() {
        return this.notices;
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public boolean removeNotice(INotice notice) {
        if (this.notices.remove(notice)) {
            this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"notices", (Object)notice, null));
            return true;
        }
        return false;
    }

    public <T extends Event> void removeNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.eventDispatcher.removeNotificationListener(type, listener);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    protected void triggerEvent(Event event) {
        this.eventDispatcher.triggerEvent(event);
    }
}

